/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.rubysonar.types;

import com.sourceclear.rubysonar.State;
import com.sourceclear.rubysonar.types.CyclicTypeRecorder;
import com.sourceclear.rubysonar.types.ListType;
import com.sourceclear.rubysonar.types.Type;
import com.sourceclear.rubysonar.types.TypeStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TupleType
implements Type {
    @NotNull
    private final State table;
    @NotNull
    private final List<Type> elementTypes;
    @NotNull
    private TypeStack typeStack = new TypeStack();

    public TupleType() {
        this(State.newGlobalTable(), new ArrayList<Type>());
    }

    public TupleType(List<Type> elementTypes) {
        this(State.newGlobalTable(), elementTypes);
    }

    public TupleType(State globalTable, @NotNull List<Type> elementTypes) {
        this.table = new State(globalTable, State.StateType.INSTANCE);
        this.elementTypes = elementTypes;
    }

    public TupleType(State globalTable, Type elt0) {
        this(globalTable, Arrays.asList(elt0));
    }

    public TupleType(Type elt0) {
        this(State.newGlobalTable(), Arrays.asList(elt0));
    }

    public TupleType(State globalTable, Type elt0, Type elt1) {
        this(globalTable, Arrays.asList(elt0, elt1));
    }

    public TupleType(Type elt0, Type elt1) {
        this(State.newGlobalTable(), Arrays.asList(elt0, elt1));
    }

    public TupleType(State globalTable, Type ... types) {
        this(globalTable, Arrays.asList(types));
    }

    public TupleType(Type ... types) {
        this(State.newGlobalTable(), Arrays.asList(types));
    }

    public void add(Type elt) {
        this.elementTypes.add(elt);
    }

    public Type get(int i) {
        return this.elementTypes.get(i);
    }

    @NotNull
    public List<Type> getElementTypes() {
        return this.elementTypes;
    }

    @Override
    @NotNull
    public State getTable() {
        return this.table;
    }

    @NotNull
    public ListType toListType() {
        ListType.ListTypeBuilder listTypeBuilder = ListType.builder();
        for (Type e : this.elementTypes) {
            listTypeBuilder.addElementType(e);
        }
        listTypeBuilder.withGlobalTable(this.table.getParent());
        return listTypeBuilder.build();
    }

    public boolean equals(Object other) {
        if (this.typeStack.contains(this, other)) {
            return true;
        }
        if (other instanceof TupleType) {
            List<Type> types1 = this.elementTypes;
            List<Type> types2 = ((TupleType)other).elementTypes;
            if (types1.size() == types2.size()) {
                this.typeStack.push(this, other);
                for (int i = 0; i < types1.size(); ++i) {
                    if (types1.get(i).equals(types2.get(i))) continue;
                    this.typeStack.pop(this, other);
                    return false;
                }
                this.typeStack.pop(this, other);
                return true;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return "TupleType".hashCode();
    }

    @Override
    public String printType(@NotNull CyclicTypeRecorder ctr) {
        StringBuilder sb = new StringBuilder();
        Integer num = ctr.visit(this);
        if (num != null) {
            sb.append("#").append(num);
        } else {
            int newNum = ctr.push(this);
            boolean first = true;
            if (this.elementTypes.size() != 1) {
                sb.append("(");
            }
            for (Type t : this.elementTypes) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(t.printType(ctr));
                first = false;
            }
            if (ctr.isUsed(this)) {
                sb.append("=#").append(newNum).append(":");
            }
            if (this.elementTypes.size() != 1) {
                sb.append(")");
            }
            ctr.pop(this);
        }
        return sb.toString();
    }

    @NotNull
    public String toString() {
        return this.printType(new CyclicTypeRecorder());
    }
}

