/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.rubysonar.types;

import com.sourceclear.rubysonar.State;
import com.sourceclear.rubysonar.types.CyclicTypeRecorder;
import com.sourceclear.rubysonar.types.Type;
import com.sourceclear.rubysonar.types.TypeStack;
import com.sourceclear.rubysonar.types.Types;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnionType
implements Type {
    @NotNull
    private final Set<Type> types;
    @NotNull
    private final State table;
    @NotNull
    private TypeStack typeStack = new TypeStack();
    private static final int MAX_UNION_SIZE = 20;

    public UnionType(Type ... initialTypes) {
        this(State.newGlobalTable(), initialTypes);
    }

    private UnionType(State globalTable, Type ... initialTypes) {
        HashSet<Type> types = new HashSet<Type>();
        for (Type type : initialTypes) {
            UnionType.addType(types, type);
        }
        this.types = types;
        this.table = new State(globalTable, State.StateType.INSTANCE);
    }

    public boolean isEmpty() {
        return this.types.isEmpty();
    }

    public static boolean contains(Type t1, Type t2) {
        if (t1 instanceof UnionType) {
            return ((UnionType)t1).contains(t2);
        }
        return t1.equals(t2);
    }

    public static Type remove(Type t1, Type t2) {
        if (t1 instanceof UnionType) {
            HashSet<Type> types = new HashSet<Type>(((UnionType)t1).types);
            types.remove(t2);
            return UnionType.newUnion(types);
        }
        if (t1 == t2) {
            return Types.UNKNOWN;
        }
        return t1;
    }

    @NotNull
    public static Type newUnion(@NotNull Collection<Type> types) {
        Type t = Types.UNKNOWN;
        for (Type nt : types) {
            t = UnionType.union(t, nt);
        }
        return t;
    }

    @NotNull
    public Set<Type> getTypes() {
        return this.types;
    }

    @Override
    @NotNull
    public State getTable() {
        return this.table;
    }

    private static void addType(@NotNull Set<Type> types, @NotNull Type t) {
        if (types.size() > 20) {
            return;
        }
        if (t instanceof UnionType) {
            types.addAll(((UnionType)t).types);
        } else {
            types.add(t);
        }
    }

    public boolean contains(Type t) {
        return this.types.contains(t);
    }

    public static Type union(Type ... types) {
        Type result = Types.UNKNOWN;
        for (Type type : types) {
            result = UnionType.union(result, type);
        }
        return result;
    }

    @NotNull
    public static Type union(@NotNull Type u, @NotNull Type v) {
        if (u.equals(v)) {
            return u;
        }
        if (u == Types.UNKNOWN) {
            return v;
        }
        if (v == Types.UNKNOWN) {
            return u;
        }
        if (u == Types.CONT) {
            return v;
        }
        if (v == Types.CONT) {
            return u;
        }
        if (u == Types.NIL) {
            return v;
        }
        if (v == Types.NIL) {
            return u;
        }
        return new UnionType(u, v);
    }

    @Nullable
    public Type firstUseful() {
        for (Type type : this.types) {
            if (type == Types.UNKNOWN || type == Types.NIL) continue;
            return type;
        }
        return null;
    }

    public boolean equals(Object other) {
        if (this.typeStack.contains(this, other)) {
            return true;
        }
        if (other instanceof UnionType) {
            Set<Type> types1 = this.types;
            Set<Type> types2 = ((UnionType)other).types;
            if (types1.size() != types2.size()) {
                return false;
            }
            this.typeStack.push(this, other);
            for (Type t : types2) {
                if (types1.contains(t)) continue;
                this.typeStack.pop(this, other);
                return false;
            }
            for (Type t : types1) {
                if (types2.contains(t)) continue;
                this.typeStack.pop(this, other);
                return false;
            }
            this.typeStack.pop(this, other);
            return true;
        }
        return false;
    }

    public int hashCode() {
        return "UnionType".hashCode();
    }

    @Override
    public String printType(@NotNull CyclicTypeRecorder ctr) {
        StringBuilder sb = new StringBuilder();
        Integer num = ctr.visit(this);
        if (num != null) {
            sb.append("#").append(num);
        } else {
            int newNum = ctr.push(this);
            boolean first = true;
            sb.append("{");
            for (Type t : this.types) {
                if (!first) {
                    sb.append(" | ");
                }
                sb.append(t.printType(ctr));
                first = false;
            }
            if (ctr.isUsed(this)) {
                sb.append("=#").append(newNum).append(":");
            }
            sb.append("}");
            ctr.pop(this);
        }
        return sb.toString();
    }

    @NotNull
    public String toString() {
        return this.printType(new CyclicTypeRecorder());
    }
}

