/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.sgl;

import com.sourceclear.sgl.lang.expr.Expr;
import com.sourceclear.sgl.lang.expr.Named;
import com.sourceclear.sgl.lang.expr.Patterns;
import com.sourceclear.sgl.lang.expr.Query;
import com.sourceclear.sgl.lang.expr.Step;
import com.sourceclear.sgl.lang.printer.ASTPrinter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class StepsToPatterns {
    private static final String START = "_start";

    public Expr preprocessPattern(List<Step> steps) {
        boolean leadingVariable;
        ArrayList<Named> result = new ArrayList<Named>();
        boolean firstStep = true;
        HashSet<String> boundVars = new HashSet<String>();
        for (Step step : steps) {
            result.addAll(this.splitStep(step, firstStep, boundVars));
            firstStep = false;
        }
        boolean bl = leadingVariable = !result.isEmpty() && !StepsToPatterns.isGenerated(((Named)result.get(0)).start());
        if (result.size() > 1 || leadingVariable) {
            return new Patterns(result);
        }
        return new Query(((Named)result.get(0)).step());
    }

    private void splitStep(Step step, Optional<String> start, List<Named> result, Set<String> boundVars) {
        Result r = this.uncons(step);
        if (r.getStep().isPresent()) {
            Optional<String> end = r.getVariable();
            String s = start.orElseThrow(() -> new RuntimeException("a match step must have exactly one starting point"));
            if (end.isPresent()) {
                boundVars.add(end.get());
                result.add(Named.create(r.getStep().get(), s, end.get()));
            } else {
                result.add(Named.create(r.getStep().get(), s));
            }
            if (r.getNext().isPresent()) {
                this.splitStep(r.getNext().get(), end, result, boundVars);
            }
        } else if (r.getVariable().isPresent() && r.getNext().isPresent()) {
            String starting = r.getVariable().get();
            if (!boundVars.contains(starting)) {
                throw new RuntimeException("use of unbound variable " + starting);
            }
            Step next = r.getNext().get();
            this.splitStep(next, Optional.of(starting), result, boundVars);
        } else {
            throw new RuntimeException(ASTPrinter.print(new Query(step)) + " is not a valid pattern fragment");
        }
    }

    private List<Named> splitStep(Step step, boolean start, Set<String> boundVars) {
        Optional<String> startVar;
        ArrayList<Named> result = new ArrayList<Named>();
        if (start) {
            boundVars.add(START);
            startVar = Optional.of(START);
        } else {
            startVar = Optional.empty();
        }
        this.splitStep(step, startVar, result, boundVars);
        return result;
    }

    private Result uncons(Step step) {
        if (StepsToPatterns.isVar(step.getName())) {
            return new Result(null, StepsToPatterns.varName(step.getName()), step.getNext());
        }
        if (step.getNext().isPresent()) {
            Result res = this.uncons(step.getNext().get());
            return new Result(step.withNext(res.step), res.variable, res.getNext());
        }
        return new Result(step, null, Optional.empty());
    }

    private static String varName(String s) {
        return s.substring(1);
    }

    private static boolean isVar(String s) {
        return s.charAt(0) == '?';
    }

    public static boolean isGenerated(String s) {
        return s.charAt(0) == '_';
    }

    private class Result {
        @Nullable
        Step step;
        @Nullable
        String variable;
        Optional<Step> next;

        public Result(@Nullable Step step, String variable, Optional<Step> next) {
            this.step = step;
            this.variable = variable;
            this.next = next;
        }

        public Optional<Step> getStep() {
            return Optional.ofNullable(this.step);
        }

        public Optional<String> getVariable() {
            return Optional.ofNullable(this.variable);
        }

        public Optional<Step> getNext() {
            return this.next;
        }
    }
}

