/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.sgl.lang.expr;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.sourceclear.sgl.lang.expr.Named;
import com.sourceclear.sgl.lang.expr.Step;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;

public final class ImmutableNamed
implements Named {
    private final Step step;
    private final String start;
    private final String end;

    private ImmutableNamed(Step step, String start, String end) {
        this.step = step;
        this.start = start;
        this.end = end;
    }

    @Override
    public Step step() {
        return this.step;
    }

    @Override
    public String start() {
        return this.start;
    }

    @Override
    public Optional<String> end() {
        return Optional.ofNullable(this.end);
    }

    public final ImmutableNamed withStep(Step value) {
        if (this.step == value) {
            return this;
        }
        Step newValue = Objects.requireNonNull(value, "step");
        return new ImmutableNamed(newValue, this.start, this.end);
    }

    public final ImmutableNamed withStart(String value) {
        if (this.start.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "start");
        return new ImmutableNamed(this.step, newValue, this.end);
    }

    public final ImmutableNamed withEnd(String value) {
        String newValue = Objects.requireNonNull(value, "end");
        if (Objects.equals(this.end, newValue)) {
            return this;
        }
        return new ImmutableNamed(this.step, this.start, newValue);
    }

    public final ImmutableNamed withEnd(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.end, value)) {
            return this;
        }
        return new ImmutableNamed(this.step, this.start, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNamed && this.equalTo((ImmutableNamed)another);
    }

    private boolean equalTo(ImmutableNamed another) {
        return this.step.equals(another.step) && this.start.equals(another.start) && Objects.equals(this.end, another.end);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.step.hashCode();
        h += (h << 5) + this.start.hashCode();
        h += (h << 5) + Objects.hashCode(this.end);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Named").omitNullValues().add("step", (Object)this.step).add("start", (Object)this.start).add("end", (Object)this.end).toString();
    }

    public static ImmutableNamed copyOf(Named instance) {
        if (instance instanceof ImmutableNamed) {
            return (ImmutableNamed)instance;
        }
        return ImmutableNamed.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_STEP = 1L;
        private static final long INIT_BIT_START = 2L;
        private long initBits = 3L;
        private Step step;
        private String start;
        private String end;

        private Builder() {
        }

        public final Builder from(Named instance) {
            Objects.requireNonNull(instance, "instance");
            this.step(instance.step());
            this.start(instance.start());
            Optional<String> endOptional = instance.end();
            if (endOptional.isPresent()) {
                this.end(endOptional);
            }
            return this;
        }

        public final Builder step(Step step) {
            this.step = Objects.requireNonNull(step, "step");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder start(String start) {
            this.start = Objects.requireNonNull(start, "start");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder end(String end) {
            this.end = Objects.requireNonNull(end, "end");
            return this;
        }

        public final Builder end(Optional<String> end) {
            this.end = end.orElse(null);
            return this;
        }

        public ImmutableNamed build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNamed(this.step, this.start, this.end);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("step");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("start");
            }
            return "Cannot build Named, some of required attributes are not set " + attributes;
        }
    }
}

