/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.util.fingerprints;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.sourceclear.util.fingerprints.ReleaseStatus;
import com.sourceclear.util.fingerprints.SemanticVersion;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.math.NumberUtils;

@Immutable
public final class Version
implements Comparable<Version> {
    private static final Pattern PATTERN = Pattern.compile("(\\w+)");
    private static final ImmutableSet<ReleaseStatus> RELEASE_IDENTIFIERS = ImmutableSet.of((Object)ReleaseStatus.DEV, (Object)ReleaseStatus.SNAPSHOT, (Object)ReleaseStatus.ALPHA, (Object)ReleaseStatus.BETA, (Object)ReleaseStatus.RELEASECANDIDATE);
    private final String versionString;
    private final List<Token> tokens;
    private final Date parsedDate;
    private final Date releaseDate;
    private final ReleaseStatus releaseStatus;
    private final boolean semanticVersioned;

    static Version fromNormalizedString(String normalizedString) {
        return Version.fromNormalizedString(normalizedString, null);
    }

    static Version fromNormalizedString(String normalizedString, Date releaseDate) {
        Matcher m = PATTERN.matcher(normalizedString);
        ImmutableList.Builder builder = new ImmutableList.Builder();
        while (m.find()) {
            builder.add((Object)m.group());
        }
        ImmutableList tokens = builder.build();
        return new Version(normalizedString, (ImmutableList<String>)tokens, releaseDate);
    }

    private Version(String versionString, ImmutableList<String> stringTokens, Date releaseDate) {
        if (stringTokens.isEmpty()) {
            throw new IllegalArgumentException("Could not parse version string " + versionString + ". Please verify the format.");
        }
        this.versionString = versionString;
        ArrayList<Token> temp = new ArrayList<Token>(stringTokens.size());
        for (String token : stringTokens) {
            temp.add(new Token(token));
        }
        this.tokens = Collections.unmodifiableList(temp);
        this.releaseDate = releaseDate;
        this.parsedDate = this.attemptToParseDateString(versionString);
        this.releaseStatus = this.calculateReleaseStatus(stringTokens.size() - 1);
        this.semanticVersioned = this.checkForSemanticVersioning();
    }

    @Nullable
    @VisibleForTesting
    public SemanticVersion getSemanticVersionDifference(Version v2) {
        if (!this.semanticVersioned || !v2.semanticVersioned) {
            return null;
        }
        for (int i = 0; i < SemanticVersion.values().length; ++i) {
            Token token;
            int thisInteger = 0;
            int v2Integer = 0;
            if (this.tokens.size() > i) {
                token = this.tokens.get(i);
                if (!token.parseable && i == 0) {
                    return null;
                }
                thisInteger = token.parsedValue;
            }
            if (v2.tokens.size() > i) {
                token = v2.tokens.get(i);
                if (!token.parseable && i == 0) {
                    return null;
                }
                v2Integer = token.parsedValue;
            }
            if (thisInteger == v2Integer) continue;
            return SemanticVersion.values()[i];
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version version = (Version)o;
        Date thisResolvedDate = (Date)ObjectUtils.firstNonNull((Object[])new Date[]{this.releaseDate, this.parsedDate});
        Date oResolvedDate = (Date)ObjectUtils.firstNonNull((Object[])new Date[]{version.releaseDate, version.parsedDate});
        if (!Objects.equals(thisResolvedDate, oResolvedDate)) {
            return false;
        }
        return Objects.equals(this.tokens, version.tokens);
    }

    public int hashCode() {
        return Objects.hash(this.versionString, this.releaseDate, this.tokens);
    }

    @Override
    public int compareTo(@Nonnull Version o) {
        Token token;
        int dateCompare;
        if ((this.parsedDate != null || o.parsedDate != null) && (dateCompare = this.compareByDate(o)) != 0) {
            return dateCompare;
        }
        if (this.versionString.equals(o.versionString)) {
            return this.compareByDate(o);
        }
        int thisTokensSize = this.tokens.size();
        int oTokensSize = o.tokens.size();
        int comparisonCount = Math.min(thisTokensSize, oTokensSize);
        for (int i = 0; i < comparisonCount; ++i) {
            int value = this.tokens.get(i).compareTo(o.tokens.get(i));
            if (value == 0) continue;
            return value;
        }
        if (thisTokensSize > comparisonCount && (token = this.tokens.get(comparisonCount)).isQualifier()) {
            return -1;
        }
        if (oTokensSize > comparisonCount && (token = o.tokens.get(comparisonCount)).isQualifier()) {
            return 1;
        }
        return thisTokensSize - oTokensSize;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int x = 0; x < this.tokens.size(); ++x) {
            if (x != 0) {
                sb.append(".");
            }
            sb.append(this.tokens.get(x).value);
        }
        return sb.toString();
    }

    private int compareByDate(@Nonnull Version o) {
        int result;
        Date thisResolvedDate = (Date)ObjectUtils.firstNonNull((Object[])new Date[]{this.releaseDate, this.parsedDate});
        Date oResolvedDate = (Date)ObjectUtils.firstNonNull((Object[])new Date[]{o.releaseDate, o.parsedDate});
        if (thisResolvedDate != null && oResolvedDate != null && (result = thisResolvedDate.compareTo(oResolvedDate)) != 0) {
            return result;
        }
        return 0;
    }

    private Date attemptToParseDateString(String dateString) {
        String[] tryFormats;
        for (String tryFormat : tryFormats = new String[]{"yyyyMMdd", "yyyy.M.d"}) {
            try {
                return new SimpleDateFormat(tryFormat).parse(dateString);
            }
            catch (ParseException parseException) {
            }
        }
        return null;
    }

    private ReleaseStatus calculateReleaseStatus(int checkToken) {
        if (checkToken < 0 || checkToken > this.tokens.size() - 1) {
            throw new IndexOutOfBoundsException("Check token outside of token size.");
        }
        String lastString = this.tokens.get(checkToken).value.toUpperCase();
        for (ReleaseStatus releaseStatus : RELEASE_IDENTIFIERS) {
            for (String s : releaseStatus.getIdentifiers()) {
                if (!lastString.contains(s.toUpperCase())) continue;
                return releaseStatus;
            }
        }
        if (checkToken > 1) {
            return this.calculateReleaseStatus(checkToken - 1);
        }
        return ReleaseStatus.RELEASE;
    }

    private boolean checkForSemanticVersioning() {
        return this.parsedDate == null;
    }

    public String getVersionString() {
        return this.versionString;
    }

    public List<Token> getTokens() {
        return this.tokens;
    }

    public ReleaseStatus getReleaseStatus() {
        return this.releaseStatus;
    }

    public boolean isSemanticVersioned() {
        return this.semanticVersioned;
    }

    @VisibleForTesting
    static class Token
    implements Comparable<Token> {
        private final String value;
        private final int parsedValue;
        private final boolean parseable;

        Token(String value) {
            this.value = value;
            int tryParseValue = 0;
            boolean successfullyParsed = false;
            try {
                tryParseValue = Integer.parseInt(value);
                successfullyParsed = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.parsedValue = tryParseValue;
            this.parseable = successfullyParsed;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Token token = (Token)o;
            return this.parsedValue == token.parsedValue && this.parseable == token.parseable && Objects.equals(this.value, token.value);
        }

        public int hashCode() {
            return Objects.hash(this.value, this.parsedValue, this.parseable);
        }

        @Override
        public int compareTo(@Nonnull Token o) {
            if (this.parseable && o.parseable) {
                return NumberUtils.compare((int)this.parsedValue, (int)o.parsedValue);
            }
            if (!this.parseable && !o.parseable) {
                return this.value.compareTo(o.value);
            }
            if (!this.parseable) {
                return -1;
            }
            return 1;
        }

        boolean isQualifier() {
            return !this.parseable;
        }

        @VisibleForTesting
        String getValue() {
            return this.value;
        }
    }
}

