/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.util.io;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.commons.lang3.SystemUtils;

public class SrcclrIo {
    private static final ExecutorService EXECUTORS = Executors.newCachedThreadPool(new ThreadFactory(){
        private final AtomicInteger count = new AtomicInteger();

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName("IO Thread " + this.count.addAndGet(1));
            t.setDaemon(true);
            return t;
        }
    });
    private static final String EXTENSION_PATTERN = "\\.((?:exe)|(?:bat)|(?:com)|(?:cmd))$";

    public static Future<String> readAsync(final InputStream is) {
        return EXECUTORS.submit(new Callable<String>(){

            @Override
            public String call() throws Exception {
                String str = new String(ByteStreams.toByteArray((InputStream)is), Charsets.UTF_8);
                is.close();
                return str;
            }
        });
    }

    public static String resolveExecutable(final String name) {
        for (String path : System.getenv("PATH").split(File.pathSeparator)) {
            File[] execs = new File(path).listFiles(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.getName().equals(name) && f.canExecute();
                }
            });
            if (execs == null || execs.length <= 0) continue;
            return execs[0].getAbsolutePath();
        }
        return null;
    }

    public static ImmutableMap<String, String> resolveExecutables(final Collection<String> names) {
        HashMap executables = Maps.newHashMap();
        String systemPath = System.getenv("PATH");
        if (systemPath != null) {
            for (String path : systemPath.split(File.pathSeparator)) {
                File[] execs = new File(path).listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        if (SystemUtils.IS_OS_WINDOWS) {
                            return Pattern.compile(SrcclrIo.EXTENSION_PATTERN).matcher(f.getName()).find() && names.contains(f.getName().replaceAll(SrcclrIo.EXTENSION_PATTERN, ""));
                        }
                        return names.contains(f.getName()) && f.canExecute();
                    }
                });
                if (execs == null) continue;
                for (File f : execs) {
                    String exeName;
                    String string = exeName = SystemUtils.IS_OS_WINDOWS ? f.getName().replaceAll(EXTENSION_PATTERN, "") : f.getName();
                    if (executables.containsKey(exeName)) continue;
                    executables.put(exeName, f.getAbsolutePath());
                }
            }
        }
        return ImmutableMap.copyOf((Map)executables);
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                EXECUTORS.shutdownNow();
            }
        });
    }
}

