/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.util.io.renderers;

import com.google.common.base.Strings;
import com.sourceclear.api.data.artifact.LibraryMatchWithArtifactsApiModel;
import com.sourceclear.api.data.diff.DiffResponse;
import com.sourceclear.api.data.evidence.Evidence;
import com.sourceclear.api.data.match.MatchResponse;
import com.sourceclear.api.data.match.ScanFinishUploadResponse;
import com.sourceclear.api.data.methods.InstanceVulnMethod;
import com.sourceclear.util.config.Commons;
import com.sourceclear.util.config.ScanConfig;
import com.srcclr.sdk.LibraryGraphContainer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;

public class ScanReport {
    private final String scanPath;
    private final long duration;
    private final long evidenceCount;
    private final long uniqueCoordsCount;
    private final long cryptographicDigestCount;
    private final long bytecodeDigestCount;
    private final int vulnerableComponents;
    private final Integer vulnerableMethods;
    private final Collection<Evidence> evidence;
    private final LibraryGraphContainer graphs;
    private final List<InstanceVulnMethod> vulnMethods;
    private final MatchResponse matchResponse;
    private final URI appBase;
    private final Long lineCount;
    private final boolean upload;
    private final ScanConfig scanConfig;
    private final List<String> collectorsList;
    private final Commons.VulnLevels failOnLevel;
    private final ScanFinishUploadResponse scanFinishUploadResponse;
    private final boolean listUnmatched;
    private final DiffResponse diffResponse;
    private final boolean showDiff;

    private ScanReport(Builder builder) {
        this.scanPath = builder.scanPath;
        this.duration = builder.duration;
        this.evidenceCount = builder.evidenceCount;
        this.uniqueCoordsCount = builder.uniqueCoordsCount;
        this.cryptographicDigestCount = builder.cryptographicDigestCount;
        this.bytecodeDigestCount = builder.bytecodeDigestCount;
        this.vulnerableComponents = builder.vulnerableComponents;
        this.vulnerableMethods = builder.vulnerableMethods;
        this.evidence = builder.evidence;
        this.graphs = builder.graphs;
        this.vulnMethods = builder.vulnMethods;
        this.matchResponse = builder.matchResponse;
        this.upload = builder.upload;
        this.appBase = builder.appBase;
        this.lineCount = builder.lineCount;
        this.scanConfig = builder.scanConfig;
        this.collectorsList = builder.collectorsList != null ? builder.collectorsList : new ArrayList();
        this.failOnLevel = builder.failOnLevel == null ? Commons.VulnLevels.NEVER : builder.failOnLevel;
        this.scanFinishUploadResponse = builder.scanFinishUploadResponse;
        this.listUnmatched = builder.listUnmatched;
        this.showDiff = builder.showDiff;
        this.diffResponse = builder.diffResponse;
    }

    public String getScanPath() {
        return this.scanPath;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getEvidenceCount() {
        return this.evidenceCount;
    }

    public long getUniqueCoordsCount() {
        return this.uniqueCoordsCount;
    }

    public long getCryptographicDigestCount() {
        return this.cryptographicDigestCount;
    }

    public long getBytecodeDigestCount() {
        return this.bytecodeDigestCount;
    }

    public int getVulnerableComponents() {
        return this.vulnerableComponents;
    }

    public Integer getVulnerableMethods() {
        return this.vulnerableMethods;
    }

    public Collection<Evidence> getEvidence() {
        return this.evidence;
    }

    public List<InstanceVulnMethod> getVulnMethods() {
        return this.vulnMethods;
    }

    public MatchResponse getMatchResponse() {
        return this.matchResponse;
    }

    public boolean isUploaded() {
        return this.upload;
    }

    public URI getAppBase() {
        return this.appBase;
    }

    public Long getLineCount() {
        return this.lineCount;
    }

    public ScanConfig getScanConfig() {
        return this.scanConfig;
    }

    public LibraryGraphContainer getGraphs() {
        return this.graphs;
    }

    public List<String> getCollectorsList() {
        return this.collectorsList;
    }

    public Commons.VulnLevels getFailOnLevel() {
        return this.failOnLevel;
    }

    @Nullable
    public ScanFinishUploadResponse getScanFinishUploadResponse() {
        return this.scanFinishUploadResponse;
    }

    public boolean shouldListUnmatched() {
        return this.listUnmatched;
    }

    @Nullable
    public DiffResponse getDiffResponse() {
        return this.diffResponse;
    }

    public boolean shouldShowDiff() {
        return this.showDiff;
    }

    public static class Builder {
        private ScanConfig scanConfig;
        private MatchResponse matchResponse;
        private Collection<Evidence> evidence;
        private LibraryGraphContainer graphs;
        private List<InstanceVulnMethod> vulnMethods;
        private String scanPath;
        private long duration;
        private long evidenceCount;
        private long uniqueCoordsCount;
        private long cryptographicDigestCount;
        private long bytecodeDigestCount;
        private int vulnerableComponents;
        private Integer vulnerableMethods;
        private boolean upload;
        private URI appBase;
        private Long lineCount;
        private List<String> collectorsList;
        private Commons.VulnLevels failOnLevel;
        private ScanFinishUploadResponse scanFinishUploadResponse;
        private boolean listUnmatched;
        private DiffResponse diffResponse;
        private boolean showDiff;

        public Builder withMatchResponse(MatchResponse matchResponse) {
            this.matchResponse = matchResponse;
            int vulnComp = 0;
            for (LibraryMatchWithArtifactsApiModel model : matchResponse.getComponents()) {
                if (model.getArtifacts().isEmpty()) continue;
                ++vulnComp;
            }
            this.vulnerableComponents = vulnComp;
            return this;
        }

        public Builder withEvidence(Collection<Evidence> evidence) {
            this.evidence = evidence;
            this.evidenceCount = evidence.size();
            HashSet<String> coords = new HashSet<String>();
            long cryptoCount = 0L;
            long bytecodeCount = 0L;
            for (Evidence e : evidence) {
                if (e.getCoordinates() != null) {
                    coords.add(e.getCoordinates().toRawString());
                }
                if (!Strings.isNullOrEmpty((String)e.getSha2())) {
                    ++cryptoCount;
                }
                if (Strings.isNullOrEmpty((String)e.getBytecodeHash())) continue;
                ++bytecodeCount;
            }
            this.uniqueCoordsCount = coords.size();
            this.cryptographicDigestCount = cryptoCount;
            this.bytecodeDigestCount = bytecodeCount;
            return this;
        }

        public Builder withMethodScanResult(List<InstanceVulnMethod> vulnMethods) {
            this.vulnMethods = vulnMethods;
            if (vulnMethods != null) {
                this.vulnerableMethods = vulnMethods.size();
            }
            return this;
        }

        public Builder withScanPath(String scanPath) {
            this.scanPath = scanPath;
            return this;
        }

        public Builder withDuration(long duration) {
            this.duration = duration;
            return this;
        }

        public Builder withUpload(boolean value) {
            this.upload = value;
            return this;
        }

        public Builder withAppBase(URI base) {
            this.appBase = base;
            return this;
        }

        public Builder withLineCount(Long lineCount) {
            this.lineCount = lineCount;
            return this;
        }

        public Builder withScanConfig(ScanConfig scanConfig) {
            this.scanConfig = scanConfig;
            return this;
        }

        public Builder withGraphs(LibraryGraphContainer graphs) {
            this.graphs = graphs;
            return this;
        }

        public Builder withCollectorsList(List<String> collectorsList) {
            this.collectorsList = collectorsList;
            return this;
        }

        public Builder withFailOn(Commons.VulnLevels failOn) {
            this.failOnLevel = failOn;
            return this;
        }

        public Builder withScanFinishUploadResponse(ScanFinishUploadResponse scanFinishUploadResponse) {
            this.scanFinishUploadResponse = scanFinishUploadResponse;
            return this;
        }

        public Builder withListUnmatched(boolean listUnmatched) {
            this.listUnmatched = listUnmatched;
            return this;
        }

        public Builder withDiffResponse(DiffResponse diffResponse) {
            this.diffResponse = diffResponse;
            return this;
        }

        public Builder withShowDiff(boolean showDiff) {
            this.showDiff = showDiff;
            return this;
        }

        public ScanReport build() {
            return new ScanReport(this);
        }
    }
}

