/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.util.system;

import com.sourceclear.util.fingerprints.Version;
import com.sourceclear.util.fingerprints.VersionResolver;
import com.sourceclear.util.system.SystemInfoResult;
import com.sourceclear.util.system.SystemItem;
import com.sourceclear.util.system.SystemItemRequirementAssessor;
import com.sourceclear.util.system.SystemItemRequirementNotMetException;

public class ComposerRequirementAssessor
implements SystemItemRequirementAssessor {
    private static final ComposerRequirementAssessor singeltonAssessor = new ComposerRequirementAssessor();
    private static final VersionResolver VERSION_RESOLVER = VersionResolver.getInstance();
    private static final Version MIN_PHP_VERSION = VERSION_RESOLVER.resolve("5.3.2");
    private static final Version MIN_COMPOSER_VERSION = VERSION_RESOLVER.resolve("1.0.0-beta1");

    public static ComposerRequirementAssessor getInstance() {
        return singeltonAssessor;
    }

    private ComposerRequirementAssessor() {
    }

    @Override
    public void assess(SystemInfoResult result) throws SystemItemRequirementNotMetException {
        SystemItem systemItem = result.getItem();
        Version resultVersion = VERSION_RESOLVER.resolve(result.getVersion());
        if (systemItem != SystemItem.PHP && systemItem != SystemItem.COMPOSER) {
            throw new RuntimeException((Object)((Object)systemItem) + " systemItem requirements should not be checked with " + this.getClass().getName());
        }
        if (systemItem == SystemItem.PHP && resultVersion.compareTo(MIN_PHP_VERSION) < 0) {
            throw new SystemItemRequirementNotMetException(String.format("The installation of PHP has version %s, which is not an acceptable version%nfor the SourceClear scan. We require PHP %s.", resultVersion.getVersionString(), MIN_PHP_VERSION.getVersionString()));
        }
        if (systemItem == SystemItem.COMPOSER && resultVersion.compareTo(MIN_COMPOSER_VERSION) < 0) {
            throw new SystemItemRequirementNotMetException(String.format("The installation of Composer has version %s, which is not an acceptable version%nfor the SourceClear scan. We require Composer %s.", resultVersion.getVersionString(), MIN_COMPOSER_VERSION.getVersionString()));
        }
    }
}

