/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.ast.ArgsNode;
import org.jrubyparser.ast.DefNode;
import org.jrubyparser.ast.NilImplicitNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.visitor.NodeVisitor;
import org.jrubyparser.lexer.yacc.ISourcePosition;
import org.jrubyparser.parser.StaticScope;

public class IterNode
extends Node
implements DefNode {
    private final Node varNode;
    private final Node bodyNode;
    private StaticScope scope;

    public IterNode(ISourcePosition position, Node args, StaticScope scope, Node body) {
        super(position, args != null && args.containsVariableAssignment || body != null && body.containsVariableAssignment);
        this.varNode = args;
        this.scope = scope;
        this.bodyNode = body;
    }

    public IterNode(ISourcePosition position, ArgsNode args, Node body, StaticScope scope) {
        super(position, args != null && args.containsVariableAssignment || body != null && body.containsVariableAssignment);
        this.varNode = args;
        this.bodyNode = body == null ? NilImplicitNode.NIL : body;
        this.scope = scope;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ITERNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitIterNode(this);
    }

    @Override
    public ArgsNode getArgsNode() {
        return (ArgsNode)this.varNode;
    }

    @Override
    public StaticScope getScope() {
        return this.scope;
    }

    @Override
    public Node getBodyNode() {
        return this.bodyNode;
    }

    public Node getVarNode() {
        return this.varNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.varNode, this.bodyNode);
    }

    @Override
    public int getEndLine() {
        return -1;
    }
}

