/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.visitor.NodeVisitor;
import org.jrubyparser.lexer.yacc.ISourcePosition;

public class Match2Node
extends Node {
    private final Node receiverNode;
    private final Node valueNode;

    public Match2Node(ISourcePosition position, Node receiverNode, Node valueNode) {
        super(position, receiverNode.containsVariableAssignment() || valueNode.containsVariableAssignment());
        assert (receiverNode != null) : "receiverNode is not null";
        assert (valueNode != null) : "valueNode is not null";
        this.receiverNode = receiverNode;
        this.valueNode = valueNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.MATCH2NODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitMatch2Node(this);
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    public Node getValueNode() {
        return this.valueNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.valueNode);
    }

    @Override
    public boolean needsDefinitionCheck() {
        return false;
    }
}

