/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.ast.NilImplicitNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.NonLocalControlFlowNode;
import org.jrubyparser.ast.visitor.NodeVisitor;
import org.jrubyparser.lexer.yacc.ISourcePosition;

public class ReturnNode
extends Node
implements NonLocalControlFlowNode {
    private final Node valueNode;

    public ReturnNode(ISourcePosition position, Node valueNode) {
        super(position, valueNode.containsVariableAssignment());
        assert (valueNode != null) : "valueNode is not null";
        this.valueNode = valueNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.RETURNNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitReturnNode(this);
    }

    @Override
    public Node getValueNode() {
        return this.valueNode;
    }

    @Override
    public boolean hasValue() {
        return this.valueNode != NilImplicitNode.NIL;
    }

    @Override
    public List<Node> childNodes() {
        return ReturnNode.createList(this.valueNode);
    }
}

