/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.util.ByteList;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.SideEffectFree;
import org.jrubyparser.ast.types.ILiteralNode;
import org.jrubyparser.ast.types.INameNode;
import org.jrubyparser.ast.visitor.NodeVisitor;
import org.jrubyparser.lexer.yacc.ISourcePosition;

public class SymbolNode
extends Node
implements ILiteralNode,
INameNode,
SideEffectFree {
    private final String name;
    private final Encoding encoding;

    public SymbolNode(ISourcePosition position, String name, Encoding encoding, int cr) {
        super(position, false);
        this.name = name;
        this.encoding = encoding == USASCIIEncoding.INSTANCE || cr == 16 ? USASCIIEncoding.INSTANCE : encoding;
    }

    public SymbolNode(ISourcePosition position, ByteList value) {
        super(position, false);
        this.name = value.toString().intern();
        if (value.getEncoding() != USASCIIEncoding.INSTANCE) {
            int size = value.realSize();
            this.encoding = value.getEncoding().strLength(value.unsafeBytes(), value.begin(), size) == size ? USASCIIEncoding.INSTANCE : value.getEncoding();
        } else {
            this.encoding = USASCIIEncoding.INSTANCE;
        }
    }

    public boolean equals(Object other) {
        return other instanceof SymbolNode && this.name.equals(((SymbolNode)other).getName()) && this.encoding == ((SymbolNode)other).getEncoding();
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.SYMBOLNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitSymbolNode(this);
    }

    public String getLexicalName() {
        return ":" + this.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }
}

