/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.html_basic.ScriptStyleBaseRenderer;
import java.io.IOException;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class ScriptRenderer
extends ScriptStyleBaseRenderer {
    protected void startElement(ResponseWriter writer, UIComponent component) throws IOException {
        writer.startElement("script", component);
        writer.writeAttribute("type", (Object)"text/javascript", "type");
    }

    protected void endElement(ResponseWriter writer) throws IOException {
        writer.endElement("script");
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String resourceSrc;
        Map attributes = component.getAttributes();
        Map contextMap = context.getAttributes();
        String name = (String)attributes.get("name");
        String library = (String)attributes.get("library");
        String key = name + library;
        if (null == name) {
            return;
        }
        if (contextMap.containsKey(key)) {
            return;
        }
        contextMap.put(key, Boolean.TRUE);
        int queryPos = name.indexOf("?");
        String query = null;
        if (queryPos > -1 && name.length() > queryPos) {
            query = name.substring(queryPos + 1);
            name = name.substring(0, queryPos);
        }
        Resource resource = context.getApplication().getResourceHandler().createResource(name, library);
        ResponseWriter writer = context.getResponseWriter();
        this.startElement(writer, component);
        if (resource == null) {
            resourceSrc = "RES_NOT_FOUND";
            if (context.isProjectStage(ProjectStage.Development)) {
                String msg = "Unable to find resource " + (library == null ? "" : library + ", ") + name;
                context.addMessage(component.getClientId(context), new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg));
            }
        } else {
            resourceSrc = resource.getRequestPath();
            if (query != null) {
                resourceSrc = resourceSrc + (resourceSrc.indexOf("?") > -1 ? "&amp;" : "?") + query;
            }
            resourceSrc = context.getExternalContext().encodeResourceURL(resourceSrc);
        }
        writer.writeURIAttribute("src", (Object)resourceSrc, "src");
        this.endElement(writer);
        super.encodeEnd(context, component);
    }
}

