/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scn.dao;

import com.sun.scn.servicetags.util.XMLUtil;
import java.util.Formatter;
import org.w3c.dom.Element;

public class Domain {
    private int domainId;
    private int parentId;
    private String domainName;
    private String orgName;

    public Domain(int domainId, String domainName, int parentId) {
        this.domainId = domainId;
        this.domainName = domainName;
        this.parentId = parentId;
    }

    public Domain(int domainId, String domainName, boolean isManager, int parentId) {
        this.domainId = domainId;
        this.domainName = domainName;
        this.parentId = parentId;
    }

    public Domain(Element e) {
        try {
            this.domainId = Integer.parseInt(XMLUtil.getRequiredTextValue(e, "domainId"));
            this.parentId = Integer.parseInt(XMLUtil.getRequiredTextValue(e, "parentId"));
            this.domainName = XMLUtil.getRequiredTextValue(e, "domainName");
        }
        catch (Exception ex) {
            this.domainId = Integer.parseInt(XMLUtil.getRequiredTextValue(e, "domainid"));
            this.parentId = Integer.parseInt(XMLUtil.getRequiredTextValue(e, "domainparentid"));
            this.domainName = XMLUtil.getRequiredTextValue(e, "domainname");
        }
        this.orgName = XMLUtil.getOptionalTextValue(e, "orgName");
    }

    public int getDomainId() {
        return this.domainId;
    }

    public int getParentId() {
        return this.parentId;
    }

    public String getDomainName() {
        if (this.domainName == null) {
            return "";
        }
        return this.domainName;
    }

    public void setDomainId(int domainId) {
        this.domainId = domainId;
    }

    public void setParentId(int parentId) {
        this.parentId = parentId;
    }

    public void setDomainName(String domainName) {
        if (domainName == null) {
            domainName = "";
        }
        this.domainName = domainName;
    }

    public String getOrgName() {
        if (this.orgName == null) {
            return "";
        }
        return this.orgName;
    }

    public String toXML() {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb);
        fmt.format("  <domain>\n", new Object[0]);
        fmt.format("    <domainid>%d</domainid>\n", this.getDomainId());
        fmt.format("    <domainname>%s</domainname>\n", this.getDomainName());
        fmt.format("    <domainparentid>%d</domainparentid>\n", this.getParentId());
        fmt.format("  </domain>\n", new Object[0]);
        return sb.toString();
    }

    public String toString() {
        return this.getDomainName();
    }
}

