/*
 * Decompiled with CFR 0.152.
 */
package com.sun.servicetag;

import com.sun.servicetag.SystemEnvironment;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

class WindowsSystemEnvironment
extends SystemEnvironment {
    WindowsSystemEnvironment() {
        String procId;
        this.getWmicResult("computersystem", "get", "model");
        this.setSystemModel(this.getWmicResult("computersystem", "get", "model"));
        this.setSystemManufacturer(this.getWmicResult("computersystem", "get", "manufacturer"));
        this.setSerialNumber(this.getWmicResult("bios", "get", "serialnumber"));
        String cpuMfr = this.getWmicResult("cpu", "get", "manufacturer");
        if (cpuMfr.length() == 0 && (procId = System.getenv("processor_identifer")) != null) {
            String[] s = procId.split(",");
            cpuMfr = s[s.length - 1].trim();
        }
        this.setCpuManufacturer(cpuMfr);
        try {
            File f = new File("TempWmicBatchFile.bat");
            if (f.exists()) {
                f.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getWmicResult(String alias, String verb, String property) {
        String res = "";
        BufferedReader in = null;
        try {
            ProcessBuilder pb = new ProcessBuilder("cmd", "/C", "WMIC", alias, verb, property);
            Process p = pb.start();
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(p.getOutputStream()));
            bw.write(13);
            bw.flush();
            bw.close();
            p.waitFor();
            if (p.exitValue() == 0) {
                in = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String line = null;
                while ((line = in.readLine()) != null) {
                    if ((line = line.trim()).length() == 0) continue;
                    res = line;
                }
                String string = res;
                return string;
            }
        }
        catch (Exception e) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        return res.trim();
    }
}

