/*
 * Copyright (c) 1997, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Distribution License v. 1.0, which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

package org.glassfish.jaxb.runtime.v2.schemagen;

import org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.ContentModelContainer;
import org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.Particle;

/**
 * Enum for model group type.
 *
 * @author Kohsuke Kawaguchi
 */
enum GroupKind {
    ALL("all"), SEQUENCE("sequence"), CHOICE("choice");

    private final String name;

    GroupKind(String name) {
        this.name = name;
    }

    /**
     * Writes the model group.
     */
    Particle write(ContentModelContainer parent) {
        return parent._element(name,Particle.class);
    }
}
