/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files.apple;

public class Flags {

    public static class Event {
        public static final int None = 0;
        public static final int MustScanSubDirs = 1;
        public static final int UserDropped = 2;
        public static final int KernelDropped = 4;
        public static final int EventIdsWrapped = 8;
        public static final int HistoryDone = 16;
        public static final int RootChanged = 32;
        public static final int Mount = 64;
        public static final int Unmount = 128;
        public static final int ItemChangeOwner = 16384;
        public static final int ItemCreated = 256;
        public static final int ItemFinderInfoMod = 8192;
        public static final int ItemInodeMetaMod = 1024;
        public static final int ItemIsDir = 131072;
        public static final int ItemIsFile = 65536;
        public static final int ItemIsHardlink = 0x100000;
        public static final int ItemIsLastHardlink = 0x200000;
        public static final int ItemIsSymlink = 262144;
        public static final int ItemModified = 4096;
        public static final int ItemRemoved = 512;
        public static final int ItemRenamed = 2048;
        public static final int ItemXattrMod = 32768;
        public static final int OwnEvent = 524288;
        public static final int ItemCloned = 0x400000;

        public static String flags(com.swoval.files.apple.Event event) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\n  mustScanSubDirs: " + event.mustScanSubDirs());
            stringBuilder.append("\n  userDropped: " + event.userDropped());
            stringBuilder.append("\n  kernelDropped: " + event.kernelDropped());
            stringBuilder.append("\n  eventIdsWrapped: " + event.eventIdsWrapped());
            stringBuilder.append("\n  historyDone: " + event.historyDone());
            stringBuilder.append("\n  rootChanged: " + event.rootChanged());
            stringBuilder.append("\n  mount: " + event.mount());
            stringBuilder.append("\n  unmount: " + event.unmount());
            stringBuilder.append("\n  itemChangeOwner: " + event.itemChangeOwner());
            stringBuilder.append("\n  itemCreated: " + event.itemCreated());
            stringBuilder.append("\n  itemFinderInfoMod: " + event.itemFinderInfoMod());
            stringBuilder.append("\n  itemInodeMetaMod: " + event.itemInodeMetaMod());
            stringBuilder.append("\n  itemIsDir: " + event.itemIsDir());
            stringBuilder.append("\n  itemIsFile: " + event.itemIsFile());
            stringBuilder.append("\n  itemIsHardlink: " + event.itemIsHardlink());
            stringBuilder.append("\n  itemIsLastHardlink: " + event.itemIsLastHardlink());
            stringBuilder.append("\n  itemIsSymlink: " + event.itemIsSymlink());
            stringBuilder.append("\n  itemModified: " + event.itemModified());
            stringBuilder.append("\n  itemRemoved: " + event.itemRemoved());
            stringBuilder.append("\n  itemRenamed: " + event.itemRenamed());
            stringBuilder.append("\n  itemXattrMod: " + event.itemXattrMod());
            stringBuilder.append("\n  ownEvent: " + event.ownEvent());
            stringBuilder.append("\n  itemCloned: " + event.itemCloned());
            return "EventStreamFlags(\n" + stringBuilder.toString() + "\n)";
        }
    }

    public static class Create {
        public final int value;

        public Create(int n) {
            this.value = n;
        }

        public Create() {
            this(0);
        }

        public int getValue() {
            return this.value;
        }

        public Create setUseCFTypes() {
            return new Create(this.value | 1);
        }

        public Create setNoDefer() {
            return new Create(this.value | 2);
        }

        public Create setWatchRoot() {
            return new Create(this.value | 4);
        }

        public Create setIgnoreSelf() {
            return new Create(this.value | 8);
        }

        public Create setFileEvents() {
            return new Create(this.value | 0x10);
        }

        public Create setMarkSelf() {
            return new Create(this.value | 0x20);
        }

        public Create setUseExtendedData() {
            return new Create(this.value | 0x40);
        }

        public boolean hasUseCFTypes() {
            return (this.value & 1) > 0;
        }

        public boolean hasNoDefer() {
            return (this.value & 2) > 0;
        }

        public boolean hasWatchRoot() {
            return (this.value & 4) > 0;
        }

        public boolean hasIgnoreSelf() {
            return (this.value & 8) > 0;
        }

        public boolean hasFileEvents() {
            return (this.value & 0x10) > 0;
        }

        public boolean hasMarkSelf() {
            return (this.value & 0x20) > 0;
        }

        public boolean hasUseExtendedData() {
            return (this.value & 0x40) > 0;
        }
    }

    private static final class CreateFlags {
        public static final int None = 0;
        public static final int UseCFTypes = 1;
        public static final int NoDefer = 2;
        public static final int WatchRoot = 4;
        public static final int IgnoreSelf = 8;
        public static final int FileEvents = 16;
        public static final int MarkSelf = 32;
        public static final int UseExtendedData = 64;

        private CreateFlags() {
        }
    }
}

