/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files;

import com.swoval.files.ArrayOps;
import com.swoval.files.DirectoryRegistry;
import com.swoval.files.DirectoryWatcher;
import com.swoval.files.Executor;
import com.swoval.files.apple.FileEvent;
import com.swoval.files.apple.FileEventsApi;
import com.swoval.files.apple.Flags;
import com.swoval.functional.Consumer;
import com.swoval.functional.Either;
import com.swoval.functional.Filter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;

public class AppleDirectoryWatcher
extends DirectoryWatcher {
    private final DirectoryRegistry directoryRegistry;
    private final Map<Path, Stream> streams = new HashMap<Path, Stream>();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final double latency;
    private final Executor callbackExecutor;
    private final Executor internalExecutor;
    private final Flags.Create flags;
    private final FileEventsApi fileEventsApi;
    private static final DefaultOnStreamRemoved DefaultOnStreamRemoved = new DefaultOnStreamRemoved();

    @Override
    public Either<IOException, Boolean> register(Path path, int n) {
        return this.register(path, this.flags, n);
    }

    public Either<IOException, Boolean> register(final Path path, final Flags.Create create, final int n) {
        Either either = this.internalExecutor.block(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return AppleDirectoryWatcher.this.registerImpl(path, create, n);
            }
        });
        if (either.isLeft() && !(either.left().getValue() instanceof IOException)) {
            throw new RuntimeException((Throwable)either.left().getValue());
        }
        return either.castLeft(IOException.class);
    }

    private boolean registerImpl(Path path, Flags.Create create, int n) {
        boolean bl = true;
        Path path2 = path;
        try {
            path2 = path.toRealPath(new LinkOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Map.Entry<Path, Stream> entry = this.find(path2);
        this.directoryRegistry.addDirectory(path, n);
        if (entry == null) {
            try {
                int n2 = this.fileEventsApi.createStream(path2.toString(), this.latency, create.getValue());
                if (n2 == -1) {
                    bl = false;
                    System.err.println("Error watching " + path2 + ".");
                } else {
                    this.removeRedundantStreams(path2);
                    this.streams.put(path2, new Stream(n2));
                }
            }
            catch (FileEventsApi.ClosedFileEventsApiException closedFileEventsApiException) {
                this.close();
                bl = false;
            }
        }
        return bl;
    }

    private void removeRedundantStreams(Path path) {
        Map.Entry<Path, Stream> entry2;
        ArrayList<Path> arrayList = new ArrayList<Path>();
        for (Map.Entry<Path, Stream> entry2 : this.streams.entrySet()) {
            Path path2 = (Path)entry2.getKey();
            if (!path2.startsWith(path) || path2.equals(path)) continue;
            arrayList.add(path2);
        }
        entry2 = arrayList.iterator();
        while (entry2.hasNext()) {
            this.unregisterImpl((Path)entry2.next());
        }
    }

    private void unregisterImpl(Path path) {
        if (!this.closed.get()) {
            this.directoryRegistry.removeDirectory(path);
            Stream stream = this.streams.remove(path);
            if (stream != null && stream.id != -1) {
                this.fileEventsApi.stopStream(stream.id);
            }
        }
    }

    @Override
    public void unregister(final Path path) {
        this.internalExecutor.block(new Runnable(){

            @Override
            public void run() {
                AppleDirectoryWatcher.this.unregisterImpl(path);
            }
        });
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            super.close();
            this.internalExecutor.block(new Runnable(){

                @Override
                public void run() {
                    AppleDirectoryWatcher.this.streams.clear();
                    AppleDirectoryWatcher.this.fileEventsApi.close();
                    AppleDirectoryWatcher.this.callbackExecutor.close();
                }
            });
            this.internalExecutor.close();
        }
    }

    private static Flags.Create fromOptionsOrDefault(DirectoryWatcher.Option ... optionArray) {
        DirectoryWatcher.Option option = ArrayOps.find(optionArray, new Filter<DirectoryWatcher.Option>(){

            @Override
            public boolean accept(DirectoryWatcher.Option option) {
                return option instanceof FlagOption;
            }
        });
        return option == null ? new Flags.Create().setFileEvents().setNoDefer() : ((FlagOption)option).getFlags();
    }

    public AppleDirectoryWatcher(Consumer<DirectoryWatcher.Event> consumer, Executor executor, DirectoryRegistry directoryRegistry, DirectoryWatcher.Option ... optionArray) throws InterruptedException {
        this(0.01, AppleDirectoryWatcher.fromOptionsOrDefault(optionArray), Executor.make("com.swoval.files.AppleDirectoryWatcher-callback-executor"), consumer, DefaultOnStreamRemoved, executor, directoryRegistry);
    }

    public AppleDirectoryWatcher(double d, Flags.Create create, final Executor executor, final Consumer<DirectoryWatcher.Event> consumer, final Consumer<String> consumer2, Executor executor2, final DirectoryRegistry directoryRegistry) throws InterruptedException {
        this.latency = d;
        this.flags = create;
        this.callbackExecutor = executor;
        this.internalExecutor = executor2 == null ? Executor.make("com.swoval.files.AppleDirectoryWatcher-internalExecutor") : executor2;
        this.directoryRegistry = directoryRegistry;
        this.fileEventsApi = FileEventsApi.apply(new Consumer<FileEvent>(){

            @Override
            public void accept(final FileEvent fileEvent) {
                AppleDirectoryWatcher.this.internalExecutor.run(new Runnable(){

                    @Override
                    public void run() {
                        String string = fileEvent.fileName;
                        Path path = Paths.get(string, new String[0]);
                        if (directoryRegistry.accept(path)) {
                            DirectoryWatcher.Event event = fileEvent.mustScanSubDirs() ? new DirectoryWatcher.Event(path, DirectoryWatcher.Event.Overflow) : (fileEvent.itemIsFile() ? (fileEvent.isNewFile() && Files.exists(path, new LinkOption[0]) ? new DirectoryWatcher.Event(path, DirectoryWatcher.Event.Create) : (fileEvent.isRemoved() || !Files.exists(path, new LinkOption[0]) ? new DirectoryWatcher.Event(path, DirectoryWatcher.Event.Delete) : new DirectoryWatcher.Event(path, DirectoryWatcher.Event.Modify))) : (Files.exists(path, new LinkOption[0]) ? new DirectoryWatcher.Event(path, DirectoryWatcher.Event.Modify) : new DirectoryWatcher.Event(path, DirectoryWatcher.Event.Delete)));
                            final DirectoryWatcher.Event event2 = event;
                            executor.run(new Runnable(){

                                @Override
                                public void run() {
                                    consumer.accept(event2);
                                }
                            });
                        }
                    }
                });
            }
        }, new Consumer<String>(){

            @Override
            public void accept(final String string) {
                AppleDirectoryWatcher.this.internalExecutor.block(new Runnable(){

                    @Override
                    public void run() {
                        new Runnable(){

                            @Override
                            public void run() {
                                AppleDirectoryWatcher.this.streams.remove(Paths.get(string, new String[0]));
                            }
                        }.run();
                    }
                });
                executor.run(new Runnable(){

                    @Override
                    public void run() {
                        consumer2.accept(string);
                    }
                });
            }
        });
    }

    private Map.Entry<Path, Stream> find(Path path) {
        Iterator<Map.Entry<Path, Stream>> iterator = this.streams.entrySet().iterator();
        Map.Entry<Path, Stream> entry = null;
        while (entry == null && iterator.hasNext()) {
            Map.Entry<Path, Stream> entry2 = iterator.next();
            if (!path.startsWith(entry2.getKey())) continue;
            entry = entry2;
        }
        return entry;
    }

    public static class Options {
        public static FlagOption flags(Flags.Create create) {
            return new FlagOption(create);
        }
    }

    public static class FlagOption
    extends DirectoryWatcher.Option {
        private final Flags.Create flags;

        public FlagOption(Flags.Create create) {
            super("FLAG_OPTION");
            this.flags = create;
        }

        public Flags.Create getFlags() {
            return this.flags;
        }
    }

    static class DefaultOnStreamRemoved
    implements Consumer<String> {
        DefaultOnStreamRemoved() {
        }

        @Override
        public void accept(String string) {
        }
    }

    private static class Stream {
        public final int id;

        Stream(int n) {
            this.id = n;
        }
    }
}

