/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files;

import com.swoval.files.ArrayOps;
import com.swoval.files.Directory;
import com.swoval.files.DirectoryRegistry;
import com.swoval.files.DirectoryWatcher;
import com.swoval.files.EntryFilters;
import com.swoval.files.Executor;
import com.swoval.files.FileCache;
import com.swoval.files.LinkOption;
import com.swoval.files.NioWrappers;
import com.swoval.files.SymlinkWatcher;
import com.swoval.functional.Consumer;
import com.swoval.functional.Either;
import com.swoval.runtime.ShutdownHooks;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;

class FileCacheImpl<T>
extends FileCache<T> {
    private final Map<Path, Directory<T>> directories = new HashMap<Path, Directory<T>>();
    private final Set<Path> pendingFiles = new HashSet<Path>();
    private final Directory.Converter<T> converter;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Executor internalExecutor;
    private final Executor callbackExecutor = Executor.make("com.swoval.files.FileCache-callback-executor");
    private final SymlinkWatcher symlinkWatcher;
    private final DirectoryRegistry registry = new DirectoryRegistry();
    private final DirectoryWatcher watcher;

    private Consumer<DirectoryWatcher.Event> callback(final Executor executor) {
        return new Consumer<DirectoryWatcher.Event>(){

            @Override
            public void accept(final DirectoryWatcher.Event event) {
                executor.run(new Runnable(){

                    @Override
                    public void run() {
                        Path path = event.path;
                        if (event.kind.equals(DirectoryWatcher.Event.Overflow)) {
                            FileCacheImpl.this.handleOverflow(path);
                        } else {
                            FileCacheImpl.this.handleEvent(path);
                        }
                    }
                });
            }
        };
    }

    FileCacheImpl(Directory.Converter<T> converter, DirectoryWatcher.Factory factory, Executor executor, FileCache.Option ... optionArray) throws InterruptedException, IOException {
        ShutdownHooks.addHook((int)1, (Runnable)new Runnable(){

            @Override
            public void run() {
                FileCacheImpl.this.close();
            }
        });
        this.internalExecutor = executor == null ? Executor.make("com.swoval.files.FileCache-callback-internalExecutor") : executor;
        this.watcher = factory.create(this.callback(this.internalExecutor.copy()), this.internalExecutor.copy(), this.registry);
        this.converter = converter;
        this.symlinkWatcher = !ArrayOps.contains(optionArray, FileCache.Option.NOFOLLOW_LINKS) ? new SymlinkWatcher((Consumer)new Consumer<Path>(){

            @Override
            public void accept(Path path) {
                FileCacheImpl.this.handleEvent(path);
            }
        }, factory, new Directory.OnError(){

            @Override
            public void apply(Path path, IOException iOException) {
                FileCacheImpl.this.observers.onError(path, iOException);
            }
        }, this.internalExecutor.copy()) : null;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            if (this.symlinkWatcher != null) {
                this.symlinkWatcher.close();
            }
            this.watcher.close();
            Iterator<Directory<T>> iterator = this.directories.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().close();
            }
            this.directories.clear();
            this.internalExecutor.close();
            this.callbackExecutor.close();
        }
    }

    @Override
    public List<Directory.Entry<T>> list(final Path path, final int n, final Directory.EntryFilter<? super T> entryFilter) {
        return (List)this.internalExecutor.block(new Callable<List<Directory.Entry<T>>>(){

            @Override
            public List<Directory.Entry<T>> call() {
                Directory directory = FileCacheImpl.this.find(path);
                if (directory == null) {
                    return new ArrayList();
                }
                if (directory.path.equals(path) && directory.getDepth() == -1) {
                    ArrayList arrayList = new ArrayList();
                    arrayList.add(directory.entry());
                    return arrayList;
                }
                return directory.list(path, n, entryFilter);
            }
        }).get();
    }

    @Override
    public Either<IOException, Boolean> register(final Path path, final int n) {
        Either either = this.watcher.register(path, n);
        if (either.isRight()) {
            either = this.internalExecutor.block(new Callable<Boolean>(){

                @Override
                public Boolean call() throws IOException {
                    return FileCacheImpl.this.doReg(path, n);
                }
            }).castLeft(IOException.class);
        }
        return either;
    }

    private boolean doReg(Path path, int n) throws IOException {
        Directory<Object> directory;
        boolean bl = false;
        this.registry.addDirectory(path, n);
        ArrayList<Directory<T>> arrayList = new ArrayList<Directory<T>>(this.directories.values());
        Collections.sort(arrayList, new Comparator<Directory<T>>(){

            @Override
            public int compare(Directory<T> directory, Directory<T> directory2) {
                return directory.path.compareTo(directory2.path);
            }
        });
        Iterator iterator = arrayList.iterator();
        Directory<Object> directory2 = null;
        while (iterator.hasNext() && directory2 == null) {
            int n2;
            directory = (Directory<Object>)iterator.next();
            if (!path.startsWith(directory.path)) continue;
            int n3 = n2 = path.equals(directory.path) ? 0 : directory.path.relativize(path).getNameCount() - 1;
            if (directory.getDepth() == Integer.MAX_VALUE || n < directory.getDepth() - n2) {
                directory2 = directory;
                continue;
            }
            if (n2 > directory.getDepth()) continue;
            bl = true;
            directory.close();
            try {
                directory2 = Directory.cached(directory.path, this.converter, n < Integer.MAX_VALUE - n2 - 1 ? n + n2 + 1 : Integer.MAX_VALUE);
                this.directories.put(directory.path, directory2);
            }
            catch (IOException iOException) {
                directory2 = null;
            }
        }
        if (directory2 == null) {
            try {
                try {
                    directory = Directory.cached(path, this.converter, n);
                }
                catch (NotDirectoryException notDirectoryException) {
                    directory = Directory.cached(path, this.converter, -1);
                }
                this.directories.put(path, directory);
                Iterator<Directory.Entry<Object>> iterator2 = directory.list(true, EntryFilters.AllPass).iterator();
                if (this.symlinkWatcher != null) {
                    while (iterator2.hasNext()) {
                        Directory.Entry<Object> entry = iterator2.next();
                        if (!entry.isSymbolicLink()) continue;
                        this.symlinkWatcher.addSymlink(entry.path, entry.isDirectory(), n - 1);
                    }
                }
                bl = true;
            }
            catch (NoSuchFileException noSuchFileException) {
                bl = this.pendingFiles.add(path);
            }
        }
        return bl;
    }

    private Directory<T> find(Path path) {
        Directory<T> directory = null;
        for (Directory<T> directory2 : this.directories.values()) {
            if (!path.startsWith(directory2.path) || directory != null && !directory2.path.startsWith(directory.path)) continue;
            directory = directory2;
        }
        return directory;
    }

    private boolean diff(Directory<T> directory, Directory<T> directory2) {
        List<Directory.Entry<Object>> list = directory.list(directory.recursive(), EntryFilters.AllPass);
        HashSet<Path> hashSet = new HashSet<Path>();
        Iterator<Directory.Entry<Object>> iterator = list.iterator();
        while (iterator.hasNext()) {
            hashSet.add(iterator.next().path);
        }
        List<Directory.Entry<Object>> list2 = directory2.list(directory.recursive(), EntryFilters.AllPass);
        HashSet<Path> hashSet2 = new HashSet<Path>();
        Iterator<Directory.Entry<Object>> iterator2 = list2.iterator();
        while (iterator2.hasNext()) {
            hashSet2.add(iterator2.next().path);
        }
        boolean bl = hashSet.size() != hashSet2.size();
        Iterator iterator3 = hashSet.iterator();
        while (iterator3.hasNext() && !bl) {
            if (!hashSet2.add((Path)iterator3.next())) continue;
            bl = true;
        }
        Iterator iterator4 = hashSet2.iterator();
        while (iterator4.hasNext() && !bl) {
            if (!hashSet.add((Path)iterator4.next())) continue;
            bl = true;
        }
        return bl;
    }

    private Directory<T> cachedOrNull(Path path, int n) {
        Directory<T> directory = null;
        try {
            directory = Directory.cached(path, this.converter, n);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return directory;
    }

    private void handleOverflow(Path path) {
        if (!this.closed.get()) {
            Iterator<Directory<T>> iterator = this.directories.values().iterator();
            ArrayList<Directory<Object>> arrayList = new ArrayList<Directory<Object>>();
            final ArrayList arrayList2 = new ArrayList();
            final ArrayList<Directory.Entry[]> arrayList3 = new ArrayList<Directory.Entry[]>();
            final ArrayList arrayList4 = new ArrayList();
            while (iterator.hasNext()) {
                Object object2;
                Directory<T> directory = iterator.next();
                if (!path.startsWith(directory.path)) continue;
                Directory<Object> directory2 = directory;
                Directory<Object> directory3 = this.cachedOrNull(directory2.path, directory2.getDepth());
                while (directory3 == null || this.diff(directory2, directory3)) {
                    if (directory3 != null) {
                        directory2 = directory3;
                    }
                    directory3 = this.cachedOrNull(directory2.path, directory2.getDepth());
                }
                HashMap<Path, Directory.Entry<Object>> hashMap = new HashMap<Path, Directory.Entry<Object>>();
                HashMap<Path, Object> hashMap2 = new HashMap<Path, Object>();
                for (Directory.Entry<Object> entry : directory.list(directory.recursive(), EntryFilters.AllPass)) {
                    hashMap.put(entry.path, entry);
                }
                for (Object object2 : directory3.list(directory.recursive(), EntryFilters.AllPass)) {
                    hashMap2.put(((Directory.Entry)object2).path, object2);
                }
                object2 = hashMap.entrySet().iterator();
                while (object2.hasNext()) {
                    Map.Entry entry = (Map.Entry)object2.next();
                    if (hashMap2.containsKey(entry.getKey())) continue;
                    arrayList4.add(entry.getValue());
                }
                for (Map.Entry entry : hashMap2.entrySet()) {
                    Directory.Entry entry2 = (Directory.Entry)hashMap.get(entry.getKey());
                    if (entry2 == null) {
                        arrayList2.add(entry.getValue());
                        continue;
                    }
                    if (entry2.equals(entry.getValue())) continue;
                    arrayList3.add(new Directory.Entry[]{entry2, (Directory.Entry)entry.getValue()});
                }
                arrayList.add(directory3);
            }
            for (Directory<Object> directory2 : arrayList) {
                this.directories.put(directory2.path, directory2);
            }
            this.callbackExecutor.run(new Runnable(){

                @Override
                public void run() {
                    Iterator iterator = arrayList2.iterator();
                    while (iterator.hasNext()) {
                        FileCacheImpl.this.observers.onCreate((Directory.Entry)iterator.next());
                    }
                    Iterator iterator2 = arrayList4.iterator();
                    while (iterator2.hasNext()) {
                        FileCacheImpl.this.observers.onDelete((Directory.Entry)iterator2.next());
                    }
                    for (Directory.Entry[] entryArray : arrayList3) {
                        FileCacheImpl.this.observers.onUpdate(entryArray[0], entryArray[1]);
                    }
                }
            });
        }
    }

    private void addCallback(List<Callback> list, final Path path, final Directory.Entry<T> entry, final Directory.Entry<T> entry2, final DirectoryWatcher.Event.Kind kind, final IOException iOException) {
        list.add(new Callback(path, kind){

            @Override
            public void run() {
                if (iOException != null) {
                    FileCacheImpl.this.observers.onError(path, iOException);
                } else if (kind.equals(DirectoryWatcher.Event.Create)) {
                    FileCacheImpl.this.observers.onCreate(entry2);
                } else if (kind.equals(DirectoryWatcher.Event.Delete)) {
                    FileCacheImpl.this.observers.onDelete(entry);
                } else if (kind.equals(DirectoryWatcher.Event.Modify)) {
                    FileCacheImpl.this.observers.onUpdate(entry, entry2);
                }
            }
        });
    }

    private void handleEvent(final Path path) {
        block16: {
            ArrayList<Callback> arrayList;
            block19: {
                block17: {
                    block18: {
                        if (this.closed.get()) break block16;
                        BasicFileAttributes basicFileAttributes = null;
                        arrayList = new ArrayList<Callback>();
                        try {
                            basicFileAttributes = NioWrappers.readAttributes((Path)path, (java.nio.file.LinkOption[])new java.nio.file.LinkOption[]{LinkOption.NOFOLLOW_LINKS});
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (basicFileAttributes == null) break block17;
                        Directory<T> directory = this.find(path);
                        if (directory == null) break block18;
                        List<Directory.Entry<T>> list = directory.list(path, 0, new Directory.EntryFilter<T>(){

                            @Override
                            public boolean accept(Directory.Entry<? extends T> entry) {
                                return path.equals(entry.path);
                            }
                        });
                        if (!list.isEmpty() || !path.equals(directory.path)) {
                            Path path2 = list.isEmpty() ? path : list.get((int)0).path;
                            try {
                                if (basicFileAttributes.isSymbolicLink() && this.symlinkWatcher != null) {
                                    this.symlinkWatcher.addSymlink(path, Files.isDirectory(path, new java.nio.file.LinkOption[0]), directory.getDepth() == Integer.MAX_VALUE ? Integer.MAX_VALUE : directory.getDepth() - 1);
                                }
                                Directory.Updates<T> iOException = directory.update(path2, Directory.Entry.getKind(path2, basicFileAttributes));
                                iOException.observe(this.callbackObserver(arrayList));
                            }
                            catch (IOException entry) {
                                this.addCallback(arrayList, path, null, null, DirectoryWatcher.Event.Error, entry);
                            }
                        }
                        break block19;
                    }
                    if (!this.pendingFiles.remove(path)) break block19;
                    try {
                        Directory<Object> directory;
                        try {
                            directory = Directory.cached(path, this.converter, this.registry.maxDepthFor(path));
                        }
                        catch (NotDirectoryException notDirectoryException) {
                            directory = Directory.cached(path, this.converter, -1);
                        }
                        this.directories.put(path, directory);
                        this.addCallback(arrayList, path, null, directory.entry(), DirectoryWatcher.Event.Create, null);
                        for (Directory.Entry<Object> object2 : directory.list(true, EntryFilters.AllPass)) {
                            this.addCallback(arrayList, object2.path, null, object2, DirectoryWatcher.Event.Create, null);
                        }
                    }
                    catch (IOException iOException) {
                        this.pendingFiles.add(path);
                    }
                    break block19;
                }
                ArrayList<Iterator<Directory.Entry<T>>> arrayList2 = new ArrayList<Iterator<Directory.Entry<T>>>();
                for (Directory<T> object : new ArrayList<Directory<T>>(this.directories.values())) {
                    if (!path.startsWith(object.path)) continue;
                    List<Directory.Entry<T>> list = object.remove(path);
                    if (object.path.equals(path)) {
                        this.pendingFiles.add(path);
                        list.add(object.entry());
                        this.directories.remove(path);
                    }
                    arrayList2.add(list.iterator());
                }
                for (Iterator iterator : arrayList2) {
                    while (iterator.hasNext()) {
                        Directory.Entry entry = (Directory.Entry)iterator.next();
                        this.addCallback(arrayList, entry.path, entry, null, DirectoryWatcher.Event.Delete, null);
                        if (this.symlinkWatcher == null) continue;
                        this.symlinkWatcher.remove(entry.path);
                    }
                }
            }
            if (!arrayList.isEmpty()) {
                this.callbackExecutor.run(new Runnable(){

                    @Override
                    public void run() {
                        Collections.sort(arrayList);
                        Iterator iterator = arrayList.iterator();
                        while (iterator.hasNext()) {
                            ((Callback)iterator.next()).run();
                        }
                    }
                });
            }
        }
    }

    private Directory.Observer<T> callbackObserver(final List<Callback> list) {
        return new Directory.Observer<T>(){

            @Override
            public void onCreate(Directory.Entry<T> entry) {
                FileCacheImpl.this.addCallback(list, entry.path, null, entry, DirectoryWatcher.Event.Create, null);
            }

            @Override
            public void onDelete(Directory.Entry<T> entry) {
                FileCacheImpl.this.addCallback(list, entry.path, entry, null, DirectoryWatcher.Event.Delete, null);
            }

            @Override
            public void onUpdate(Directory.Entry<T> entry, Directory.Entry<T> entry2) {
                FileCacheImpl.this.addCallback(list, entry.path, entry, entry2, DirectoryWatcher.Event.Modify, null);
            }

            @Override
            public void onError(Path path, IOException iOException) {
                FileCacheImpl.this.addCallback(list, path, null, null, DirectoryWatcher.Event.Error, iOException);
            }
        };
    }

    private abstract class Callback
    implements Runnable,
    Comparable<Callback> {
        private final DirectoryWatcher.Event.Kind kind;
        private final Path path;

        Callback(Path path, DirectoryWatcher.Event.Kind kind) {
            this.kind = kind;
            this.path = path;
        }

        @Override
        public int compareTo(Callback callback) {
            int n = this.kind.compareTo(callback.kind);
            return n == 0 ? this.path.compareTo(callback.path) : n;
        }
    }
}

