/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files;

import com.swoval.files.LinkOption;
import com.swoval.files.QuickListerImpl;
import com.swoval.runtime.NativeLoader;
import com.swoval.runtime.Platform;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;

class NativeQuickLister
extends QuickListerImpl {
    private static boolean loaded;

    public static boolean available() {
        return loaded;
    }

    @Override
    protected QuickListerImpl.ListResults listDir(String string, boolean bl) throws IOException {
        return this.fillResults(string, bl, 0);
    }

    private native int errno(long var1);

    private native String strerror(int var1);

    private native long openDir(String var1);

    private native void closeDir(long var1);

    private native long nextFile(long var1);

    private native int getType(long var1);

    private native String getName(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QuickListerImpl.ListResults fillResults(String string, boolean bl, int n) throws IOException {
        QuickListerImpl.ListResults listResults = new QuickListerImpl.ListResults();
        long l = Platform.isWin() ? this.openDir(string + "\\*") : this.openDir(string);
        int n2 = this.errno(l);
        switch (n2) {
            case -4: 
            case 8: {
                break;
            }
            case -1: {
                throw new NoSuchFileException(string);
            }
            case -2: {
                throw new AccessDeniedException(string);
            }
            case -3: {
                throw new NotDirectoryException(string);
            }
            case 0: {
                break;
            }
            default: {
                if (Platform.isWin() && n < 10) {
                    try {
                        Thread.sleep(2L);
                        return this.fillResults(string, bl, n + 1);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                throw new UnixException(n2);
            }
        }
        try {
            long l2 = this.nextFile(l);
            while (l2 != 0L) {
                int n3 = this.getType(l2);
                switch (n3) {
                    case 8: {
                        break;
                    }
                    case 1: {
                        listResults.addDir(this.getName(l2));
                        break;
                    }
                    case 2: {
                        listResults.addFile(this.getName(l2));
                        break;
                    }
                    case 4: {
                        listResults.addSymlink(this.getName(l2));
                        break;
                    }
                    default: {
                        Path path = Paths.get(string, new String[0]);
                        String string2 = this.getName(l2);
                        Path path2 = path.resolve(string2);
                        BasicFileAttributes basicFileAttributes = Files.readAttributes(path2, BasicFileAttributes.class, new java.nio.file.LinkOption[]{LinkOption.NOFOLLOW_LINKS});
                        if (basicFileAttributes.isDirectory()) {
                            listResults.addDir(string2);
                            break;
                        }
                        if (basicFileAttributes.isSymbolicLink()) {
                            listResults.addSymlink(string2);
                            break;
                        }
                        listResults.addFile(string2);
                    }
                }
                l2 = this.nextFile(l);
            }
        }
        finally {
            this.closeDir(l);
        }
        return listResults;
    }

    static {
        try {
            NativeLoader.loadPackaged();
            loaded = true;
        }
        catch (IOException | UnsatisfiedLinkError throwable) {
            loaded = false;
        }
    }

    class UnixException
    extends IOException {
        UnixException(int n) {
            super(NativeQuickLister.this.strerror(n));
        }
    }
}

