/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.server.PwaRegistry;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.jsoup.nodes.Element;

public class PwaIcon
implements Serializable {
    private final boolean shouldBeCached;
    private final int width;
    private final int height;
    private long fileHash;
    private String baseName;
    private Domain domain;
    private byte[] data;
    private final Map<String, String> attributes = new HashMap<String, String>();
    private String tag = "link";
    private PwaRegistry registry;

    PwaIcon(int width, int height, String baseName) {
        this(width, height, baseName, Domain.HEADER);
    }

    PwaIcon(int width, int height, String baseName, Domain domain) {
        this(width, height, baseName, domain, false);
    }

    PwaIcon(int width, int height, String baseName, Domain domain, boolean shouldBeCached) {
        this(width, height, baseName, domain, shouldBeCached, "icon", "");
    }

    PwaIcon(int width, int height, String baseName, Domain domain, boolean shouldBeCached, String rel, String media) {
        this.width = width;
        this.height = height;
        this.baseName = baseName;
        this.domain = domain;
        this.shouldBeCached = shouldBeCached;
        this.attributes.put("type", "image/png");
        this.attributes.put("rel", rel);
        this.attributes.put("sizes", width + "x" + height);
        if (media != null && !media.isEmpty()) {
            this.attributes.put("media", media);
        }
        this.setRelativeName();
    }

    protected PwaIcon(PwaIcon icon) {
        this.width = icon.width;
        this.height = icon.height;
        this.baseName = icon.baseName;
        this.domain = icon.domain;
        this.shouldBeCached = icon.shouldBeCached;
        this.attributes.putAll(icon.attributes);
    }

    public Element asElement() {
        Element element = new Element(this.tag);
        this.attributes.forEach((arg_0, arg_1) -> ((Element)element).attr(arg_0, arg_1));
        return element;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean shouldBeCached() {
        return this.shouldBeCached;
    }

    private void setRelativeName() {
        int split = this.baseName.lastIndexOf(46);
        String link = this.baseName.substring(0, split) + "-" + this.getSizes() + this.baseName.substring(split);
        if (!this.shouldBeCached) {
            link = link + "?" + this.fileHash;
        }
        this.attributes.put("href", link);
    }

    public String getSizes() {
        return this.attributes.get("sizes");
    }

    public String getHref() {
        return this.attributes.get("href");
    }

    public String getRelHref() {
        String[] split = this.getHref().split("\\?");
        return "/" + split[0];
    }

    public String getCacheFormat() {
        return String.format("{ url: '%s', revision: '%s' }", this.getHref(), this.fileHash);
    }

    public String getType() {
        return this.attributes.get("type");
    }

    String getRel() {
        return this.attributes.get("rel");
    }

    public Domain getDomain() {
        return this.domain;
    }

    public void setRegistry(PwaRegistry registry) {
        this.registry = registry;
    }

    public void setImage(BufferedImage image) {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)image, "png", stream);
            stream.flush();
            this.data = stream.toByteArray();
            this.fileHash = Arrays.hashCode(this.data);
            this.setRelativeName();
        }
        catch (IOException ioe) {
            throw new UncheckedIOException("Failed to write an image ", ioe);
        }
    }

    void setImage(InputStream image) throws IOException {
        if (image != null) {
            this.data = image.readAllBytes();
            this.fileHash = Arrays.hashCode(this.data);
            this.setRelativeName();
        }
    }

    boolean isAvailable() {
        return this.data != null || this.registry.getBaseImage() != null;
    }

    public void write(OutputStream outputStream) {
        if (this.data == null) {
            this.setImage(this.drawIconImage(this.getBaseImage()));
        }
        try {
            outputStream.write(this.data);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException("Failed to store the icon image into the stream provided", ioe);
        }
    }

    protected BufferedImage getBaseImage() {
        return this.registry.getBaseImage();
    }

    private BufferedImage drawIconImage(BufferedImage baseImage) {
        int bgColor = baseImage.getRGB(0, 0);
        BufferedImage bimage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        Graphics2D graphics = bimage.createGraphics();
        graphics.setBackground(new Color(bgColor, true));
        graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
        float ratio = (float)baseImage.getWidth() / (float)this.getWidth() > (float)baseImage.getHeight() / (float)this.getHeight() ? (float)baseImage.getWidth() / (float)this.getWidth() : (float)baseImage.getHeight() / (float)this.getHeight();
        ratio = ratio > 1.0f ? ratio : 1.0f;
        int newWidth = Math.round((float)baseImage.getHeight() / ratio);
        int newHeight = Math.round((float)baseImage.getWidth() / ratio);
        graphics.drawImage(baseImage.getScaledInstance(newWidth, newHeight, 4), (this.getWidth() - newWidth) / 2, (this.getHeight() - newHeight) / 2, null);
        graphics.dispose();
        return bimage;
    }

    public static enum Domain {
        HEADER,
        MANIFEST;

    }
}

