/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.UrlUtil;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.server.HttpStatusCode;
import com.vaadin.flow.server.RequestHandler;
import com.vaadin.flow.server.StreamReceiver;
import com.vaadin.flow.server.StreamResource;
import com.vaadin.flow.server.StreamResourceRegistry;
import com.vaadin.flow.server.UploadException;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.StreamReceiverHandler;
import com.vaadin.flow.server.communication.StreamResourceHandler;
import com.vaadin.flow.server.streams.UploadHandler;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamRequestHandler
implements RequestHandler {
    private static final char PATH_SEPARATOR = '/';
    public static final String DYN_RES_PREFIX = "VAADIN/dynamic/resource/";
    private final StreamResourceHandler resourceHandler = new StreamResourceHandler();
    private final StreamReceiverHandler receiverHandler;

    public StreamRequestHandler() {
        this(new StreamReceiverHandler());
    }

    protected StreamRequestHandler(StreamReceiverHandler receiverHandler) {
        receiverHandler.setRequestSizeMax(this.getRequestSizeMax());
        receiverHandler.setFileSizeMax(this.getFileSizeMax());
        receiverHandler.setFileCountMax(this.getFileCountMax());
        this.receiverHandler = receiverHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
        Optional abstractStreamResource;
        String pathInfo = request.getPathInfo();
        if (pathInfo == null) {
            return false;
        }
        assert (pathInfo.startsWith(Character.toString('/')));
        if (!(pathInfo = pathInfo.substring(1)).startsWith(DYN_RES_PREFIX)) {
            return false;
        }
        session.lock();
        try {
            abstractStreamResource = StreamRequestHandler.getPathUri(pathInfo).flatMap(session.getResourceRegistry()::getResource);
            if (abstractStreamResource.isEmpty()) {
                response.sendError(HttpStatusCode.NOT_FOUND.getCode(), "Resource is not found for path=" + pathInfo);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            session.unlock();
        }
        AbstractStreamResource resource = (AbstractStreamResource)abstractStreamResource.get();
        if (resource instanceof StreamResourceRegistry.ElementStreamResource) {
            StreamResourceRegistry.ElementStreamResource elementRequest = (StreamResourceRegistry.ElementStreamResource)resource;
            this.callElementResourceHandler(session, request, response, elementRequest, pathInfo);
        } else if (resource instanceof StreamResource) {
            this.resourceHandler.handleRequest(session, request, response, (StreamResource)resource);
        } else if (resource instanceof StreamReceiver) {
            StreamReceiver streamReceiver = (StreamReceiver)resource;
            PathData parts = this.parsePath(pathInfo);
            this.receiverHandler.handleRequest(session, request, response, streamReceiver, parts.UIid, parts.securityKey);
        } else {
            StreamRequestHandler.getLogger().warn("Received unknown stream resource.");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callElementResourceHandler(VaadinSession session, VaadinRequest request, VaadinResponse response, StreamResourceRegistry.ElementStreamResource elementRequest, String pathInfo) throws IOException {
        Element owner = elementRequest.getOwner();
        StateNode node = owner.getNode();
        session.lock();
        try {
            if (StreamRequestHandler.blockInert(elementRequest, node) || StreamRequestHandler.blockDisabled(elementRequest, node) || !node.isAttached() || !node.isVisible()) {
                response.sendError(HttpStatusCode.FORBIDDEN.getCode(), "Resource not available");
                return;
            }
            if (elementRequest.getElementRequestHandler() instanceof UploadHandler) {
                PathData parts = this.parsePath(pathInfo);
                String secKey = elementRequest.getId();
                if (secKey == null || !MessageDigest.isEqual(secKey.getBytes(StandardCharsets.UTF_8), parts.securityKey.getBytes(StandardCharsets.UTF_8))) {
                    LoggerFactory.getLogger(StreamRequestHandler.class).warn("Received incoming stream with faulty security key.");
                    response.sendError(HttpStatusCode.FORBIDDEN.getCode(), "Resource not available");
                    return;
                }
                elementRequest.getOwner().getComponent().ifPresent(value -> ComponentUtil.setData(value, "uiid", parts.UIid));
                if (node == null) {
                    session.getErrorHandler().error(new ErrorEvent(new UploadException("File upload ignored because the node for the upload owner component was not found")));
                    response.sendError(HttpStatusCode.FORBIDDEN.getCode(), "Resource not available");
                    return;
                }
                if (!node.isAttached()) {
                    session.getErrorHandler().error(new ErrorEvent(new UploadException("Warning: file upload ignored for " + node.getId() + " because the component was disabled")));
                    response.sendError(HttpStatusCode.FORBIDDEN.getCode(), "Resource not available");
                    return;
                }
            }
        }
        finally {
            session.unlock();
        }
        elementRequest.getElementRequestHandler().handleRequest(request, response, session, elementRequest.getOwner());
    }

    private static boolean blockDisabled(StreamResourceRegistry.ElementStreamResource elementRequest, StateNode node) {
        return !node.isEnabled() && elementRequest.getElementRequestHandler().getDisabledUpdateMode() == DisabledUpdateMode.ONLY_WHEN_ENABLED;
    }

    private static boolean blockInert(StreamResourceRegistry.ElementStreamResource elementRequest, StateNode node) {
        return node.isInert() && !elementRequest.getElementRequestHandler().isAllowInert();
    }

    private PathData parsePath(String pathInfo) {
        int startOfData = pathInfo.indexOf(DYN_RES_PREFIX) + DYN_RES_PREFIX.length();
        String uppUri = pathInfo.substring(startOfData);
        String[] split = uppUri.split("/", 3);
        if (split.length == 3) {
            return new PathData(split[0], split[1], split[2]);
        }
        return new PathData(split[0], split[1], "");
    }

    public static String generateURI(String name, String id) {
        return DYN_RES_PREFIX + UI.getCurrent().getUIId() + "/" + id + "/" + UrlUtil.encodeURIComponent(name);
    }

    private static Optional<URI> getPathUri(String path) {
        boolean hasPrefix;
        int index = path.lastIndexOf(47);
        boolean bl = hasPrefix = index >= 0;
        if (!hasPrefix) {
            StreamRequestHandler.getLogger().info("Unsupported path structure, path={}", (Object)path);
            return Optional.empty();
        }
        String prefix = path.substring(0, index + 1);
        String name = path.substring(prefix.length());
        try {
            URI uri = new URI(prefix + UrlUtil.encodeURIComponent(name));
            return Optional.of(uri);
        }
        catch (URISyntaxException e) {
            StreamRequestHandler.getLogger().info("Path '{}' is not correct URI (it violates RFC 2396)", (Object)path, (Object)e);
            return Optional.empty();
        }
    }

    protected long getRequestSizeMax() {
        return -1L;
    }

    protected long getFileSizeMax() {
        return -1L;
    }

    protected long getFileCountMax() {
        return 10000L;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)StreamResourceHandler.class.getName());
    }

    private record PathData(String UIid, String securityKey, String fileName) {
    }
}

