/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.push;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.vaadin.hilla.EndpointInvoker;
import com.vaadin.hilla.EndpointProperties;
import com.vaadin.hilla.push.PushEndpoint;
import com.vaadin.hilla.push.PushMessageHandler;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.atmosphere.client.TrackMessageSizeInterceptor;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.ContainerInitializer;
import org.atmosphere.interceptor.AtmosphereResourceLifecycleInterceptor;
import org.atmosphere.interceptor.SuspendTrackerInterceptor;
import org.atmosphere.util.SimpleBroadcaster;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PushConfigurer {
    private static final String HILLA_PUSH_PATH = "/HILLA/push";
    private final EndpointProperties endpointProperties;

    public PushConfigurer(EndpointProperties endpointProperties) {
        this.endpointProperties = endpointProperties;
    }

    @Bean
    PushEndpoint pushEndpoint(@Qualifier(value="hillaEndpointObjectMapper") ObjectMapper objectMapper, PushMessageHandler pushMessageHandler) {
        return new PushEndpoint(objectMapper, pushMessageHandler);
    }

    @Bean
    PushMessageHandler pushMessageHandler(EndpointInvoker endpointInvoker) {
        return new PushMessageHandler(endpointInvoker);
    }

    @Bean
    EmbeddedAtmosphereInitializer atmosphereInitializer() {
        return new EmbeddedAtmosphereInitializer();
    }

    @Bean
    ServletRegistrationBean<AtmosphereServlet> atmosphereServlet(PushEndpoint pushEndpoint) {
        String hillaPushPath = this.getHillaPushPath();
        AtmosphereServlet atmosphereServlet = new AtmosphereServlet();
        ServletRegistrationBean registration = new ServletRegistrationBean((Servlet)atmosphereServlet, new String[]{hillaPushPath});
        List<AtmosphereInterceptor> interceptors = Arrays.asList(new AtmosphereResourceLifecycleInterceptor(), new TrackMessageSizeInterceptor(), new SuspendTrackerInterceptor());
        AtmosphereFramework fw = atmosphereServlet.framework();
        fw.setDefaultBroadcasterClassName(SimpleBroadcaster.class.getName());
        fw.addAtmosphereHandler(hillaPushPath, (AtmosphereHandler)pushEndpoint, interceptors);
        registration.addInitParameter("org.atmosphere.container.JSR356AsyncSupport.mappingPath", hillaPushPath);
        registration.setLoadOnStartup(0);
        registration.setOrder(Integer.MIN_VALUE);
        return registration;
    }

    private String getHillaPushPath() {
        String prefix = this.endpointProperties.getEndpointPrefix().replaceFirst("(^|\\/)connect$", "");
        prefix = prefix.startsWith("/") ? prefix.substring(1) : prefix;
        return prefix.isEmpty() ? HILLA_PUSH_PATH : "/" + prefix + HILLA_PUSH_PATH;
    }

    static class EmbeddedAtmosphereInitializer
    extends ContainerInitializer
    implements ServletContextInitializer {
        EmbeddedAtmosphereInitializer() {
        }

        public void onStartup(ServletContext servletContext) throws ServletException {
            this.onStartup(Collections.emptySet(), servletContext);
        }
    }
}

