package com.vaadin.pro.licensechecker.dau;

import java.util.Collection;
import java.util.Collections;

/**
 * Represents a response from the DAU server.
 */
final class DAUServerResponse {

    private final EnforcementRule enforcementRule;
    private final Collection<TrackedUser> trackedUsers;

    public DAUServerResponse(EnforcementRule enforcementRule) {
        this(enforcementRule, Collections.emptyList());
    }

    /**
     * Creates a new {@link DAUServerResponse} with the given enforcement rule
     * and tracked users.
     *
     * @param enforcementRule
     *            the enforcement rule
     * @param trackedUsers
     *            the tracked users
     */
    public DAUServerResponse(EnforcementRule enforcementRule,
            Collection<TrackedUser> trackedUsers) {
        this.enforcementRule = enforcementRule;
        this.trackedUsers = trackedUsers;
    }

    public EnforcementRule getEnforcementRule() {
        return enforcementRule;
    }

    public Collection<TrackedUser> getTrackedUsers() {
        return trackedUsers;
    }
}
