/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.checkbox;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.ClickNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasAriaLabel;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.html.Label;
import com.vaadin.flow.component.shared.HasClientValidation;
import com.vaadin.flow.component.shared.HasValidationProperties;
import com.vaadin.flow.component.shared.InputField;
import com.vaadin.flow.component.shared.ValidationUtil;
import com.vaadin.flow.component.shared.internal.ValidationController;
import com.vaadin.flow.data.binder.HasValidator;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.PropertyChangeListener;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

@Tag(value="vaadin-checkbox")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.8.5"), @NpmPackage(value="@vaadin/checkbox", version="24.8.5")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/checkbox/src/vaadin-checkbox.js")})
public class Checkbox
extends AbstractSinglePropertyField<Checkbox, Boolean>
implements ClickNotifier<Checkbox>,
Focusable<Checkbox>,
HasAriaLabel,
HasClientValidation,
HasValidationProperties,
HasValidator<Boolean>,
InputField<AbstractField.ComponentValueChangeEvent<Checkbox, Boolean>, Boolean> {
    private final Label labelElement;
    private static final PropertyChangeListener NO_OP = (PropertyChangeListener & Serializable)event -> {};
    private CheckboxI18n i18n;
    private Validator<Boolean> defaultValidator = (Validator & Serializable)(value, context) -> {
        boolean fromComponent = context == null;
        boolean isRequired = fromComponent && this.isRequiredIndicatorVisible();
        return ValidationUtil.validateRequiredConstraint((String)this.getI18nErrorMessage(CheckboxI18n::getRequiredErrorMessage), (boolean)isRequired, (Object)((Boolean)this.getValue()), (Object)((Boolean)this.getEmptyValue()));
    };
    private ValidationController<Checkbox, Boolean> validationController = new ValidationController((Component)this);

    public Checkbox() {
        super("checked", (Object)false, false);
        this.getElement().setProperty("manualValidation", true);
        this.getElement().addPropertyChangeListener("indeterminate", "indeterminate-changed", NO_OP);
        this.getElement().addPropertyChangeListener("checked", "checked-changed", NO_OP);
        if (this.getElement().getProperty("checked") == null) {
            this.setPresentationValue(false);
        }
        this.setIndeterminate(false);
        this.labelElement = new Label();
        this.labelElement.getElement().setAttribute("slot", "label");
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.validate());
    }

    public Checkbox(String labelText) {
        this();
        this.setLabel(labelText);
    }

    public Checkbox(boolean initialValue) {
        this();
        this.setValue(initialValue);
    }

    public Checkbox(String labelText, boolean initialValue) {
        this(labelText);
        this.setValue(initialValue);
    }

    public Checkbox(String label, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<Checkbox, Boolean>> listener) {
        this(label);
        this.addValueChangeListener(listener);
    }

    public Checkbox(boolean initialValue, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<Checkbox, Boolean>> listener) {
        this(initialValue);
        this.addValueChangeListener(listener);
    }

    public Checkbox(String labelText, boolean initialValue, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<Checkbox, Boolean>> listener) {
        this(labelText, initialValue);
        this.addValueChangeListener(listener);
    }

    public void setRequiredIndicatorVisible(boolean required) {
        super.setRequiredIndicatorVisible(required);
    }

    public boolean isRequiredIndicatorVisible() {
        return super.isRequiredIndicatorVisible();
    }

    public String getLabel() {
        return this.getElement().getProperty("label");
    }

    public void setLabel(String label) {
        if (this.getElement().equals((Object)this.labelElement.getElement().getParent())) {
            this.getElement().removeChild(new Element[]{this.labelElement.getElement()});
        }
        this.getElement().setProperty("label", label == null ? "" : label);
    }

    public void setLabelComponent(Component component) {
        this.setLabel("");
        this.getElement().appendChild(new Element[]{this.labelElement.getElement()});
        this.labelElement.removeAll();
        this.labelElement.add(new Component[]{component});
    }

    public void setAriaLabel(String ariaLabel) {
        this.getElement().setProperty("accessibleName", ariaLabel);
    }

    public Optional<String> getAriaLabel() {
        return Optional.ofNullable(this.getElement().getProperty("accessibleName"));
    }

    public void setAriaLabelledBy(String ariaLabelledBy) {
        this.getElement().setProperty("accessibleNameRef", ariaLabelledBy);
    }

    public Optional<String> getAriaLabelledBy() {
        return Optional.ofNullable(this.getElement().getProperty("accessibleNameRef"));
    }

    public void setAutofocus(boolean autofocus) {
        this.getElement().setProperty("autofocus", autofocus);
    }

    public boolean isAutofocus() {
        return this.getElement().getProperty("autofocus", false);
    }

    public void setIndeterminate(boolean indeterminate) {
        this.getElement().setProperty("indeterminate", indeterminate);
    }

    @Synchronize(property="indeterminate", value={"indeterminate-changed"})
    public boolean isIndeterminate() {
        return this.getElement().getProperty("indeterminate", false);
    }

    public void setManualValidation(boolean enabled) {
        this.validationController.setManualValidation(enabled);
    }

    public Validator<Boolean> getDefaultValidator() {
        return this.defaultValidator;
    }

    protected void validate() {
        this.validationController.validate((Object)((Boolean)this.getValue()));
    }

    void setDisabled(boolean disabled) {
        this.getElement().setProperty("disabled", disabled);
    }

    boolean isDisabledBoolean() {
        return this.getElement().getProperty("disabled", false);
    }

    public CheckboxI18n getI18n() {
        return this.i18n;
    }

    public void setI18n(CheckboxI18n i18n) {
        this.i18n = Objects.requireNonNull(i18n, "The i18n properties object should not be null");
    }

    private String getI18nErrorMessage(Function<CheckboxI18n, String> getter) {
        return Optional.ofNullable(this.i18n).map(getter).orElse("");
    }

    public static class CheckboxI18n
    implements Serializable {
        private String requiredErrorMessage;

        public String getRequiredErrorMessage() {
            return this.requiredErrorMessage;
        }

        public CheckboxI18n setRequiredErrorMessage(String errorMessage) {
            this.requiredErrorMessage = errorMessage;
            return this;
        }
    }
}

