/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring.data;

import com.vaadin.flow.data.provider.CallbackDataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.provider.SortDirection;
import java.io.Serializable;
import java.util.stream.Collectors;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.PagingAndSortingRepository;

public interface VaadinSpringDataHelpers
extends Serializable {
    public static Sort toSpringDataSort(Query<?, ?> vaadinQuery) {
        return Sort.by(vaadinQuery.getSortOrders().stream().map(so -> so.getDirection() == SortDirection.ASCENDING ? Sort.Order.asc((String)((String)so.getSorted())) : Sort.Order.desc((String)((String)so.getSorted()))).collect(Collectors.toList()));
    }

    public static PageRequest toSpringPageRequest(Query<?, ?> vaadinQuery) {
        Sort sort = VaadinSpringDataHelpers.toSpringDataSort(vaadinQuery);
        return PageRequest.of((int)vaadinQuery.getPage(), (int)vaadinQuery.getPageSize(), (Sort)sort);
    }

    public static <T> CallbackDataProvider.FetchCallback<T, Void> fromPagingRepository(PagingAndSortingRepository<T, ?> repo) {
        return (CallbackDataProvider.FetchCallback & Serializable)query -> repo.findAll((Pageable)VaadinSpringDataHelpers.toSpringPageRequest(query)).stream();
    }
}

