/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring.scopes;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.page.ExtendedClientDetails;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.router.AfterNavigationEvent;
import com.vaadin.flow.router.AfterNavigationListener;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEnterListener;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.server.SessionDestroyListener;
import com.vaadin.flow.server.UIInitEvent;
import com.vaadin.flow.server.UIInitListener;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.spring.annotation.RouteScopeOwner;
import com.vaadin.flow.spring.scopes.AbstractScope;
import com.vaadin.flow.spring.scopes.BeanStore;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.lang.NonNull;

public class VaadinRouteScope
extends AbstractScope {
    public static final String VAADIN_ROUTE_SCOPE_NAME = "vaadin-route";
    private ConfigurableListableBeanFactory beanFactory;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        beanFactory.registerScope(VAADIN_ROUTE_SCOPE_NAME, (Scope)this);
        beanFactory.registerSingleton(NavigationListenerRegistrar.class.getName(), (Object)new NavigationListenerRegistrar());
        this.beanFactory = beanFactory;
    }

    public String getConversationId() {
        return this.getVaadinSession().getSession().getId() + "-route-scope";
    }

    @Override
    public Object get(String name, ObjectFactory<?> objectFactory) {
        return super.get(name, new RouteScopeObjectFactory(objectFactory, (RouteScopeOwner)this.beanFactory.findAnnotationOnBean(name, RouteScopeOwner.class)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BeanStore getBeanStore() {
        VaadinSession session = this.getVaadinSession();
        session.getLockInstance().lock();
        try {
            RouteBeanStore store = VaadinRouteScope.getBeanStoreIfExists(session);
            if (store == null) {
                RouteStoreWrapper wrapper = new RouteStoreWrapper(session);
                session.setAttribute(RouteStoreWrapper.class, (Object)wrapper);
                store = wrapper.getBeanStore(VaadinRouteScope.getUI());
            }
            RouteBeanStore routeBeanStore = store;
            return routeBeanStore;
        }
        finally {
            session.getLockInstance().unlock();
        }
    }

    private static RouteBeanStore getBeanStoreIfExists(VaadinSession session) {
        assert (session.hasLock());
        RouteStoreWrapper wrapper = (RouteStoreWrapper)session.getAttribute(RouteStoreWrapper.class);
        if (wrapper == null) {
            return null;
        }
        return wrapper.getBeanStore(VaadinRouteScope.getUI());
    }

    private static String getWindowName(UI ui) {
        ExtendedClientDetails details = ui.getInternals().getExtendedClientDetails();
        if (details == null) {
            return null;
        }
        return details.getWindowName();
    }

    private static UI getUI() {
        UI ui = UI.getCurrent();
        if (ui == null) {
            throw new IllegalStateException("There is no UI available. The route scope is not active");
        }
        return ui;
    }

    private static UI findPreservingUI(UI ui) {
        VaadinSession session = ui.getSession();
        String windowName = VaadinRouteScope.getWindowName(ui);
        for (UI sessionUi : session.getUIs()) {
            if (sessionUi == ui || windowName == null || !windowName.equals(VaadinRouteScope.getWindowName(sessionUi))) continue;
            return sessionUi;
        }
        return null;
    }

    static class NavigationListenerRegistrar
    implements UIInitListener {
        NavigationListenerRegistrar() {
        }

        public void uiInit(UIInitEvent event) {
            NavigationListener listener = new NavigationListener(event.getUI());
            ComponentUtil.setData((Component)event.getUI(), NavigationListener.class, (Object)listener);
        }
    }

    private static class RouteScopeObjectFactory
    implements ObjectFactory<ObjectWithOwner> {
        private final ObjectFactory<?> objectFactory;
        private final RouteScopeOwner owner;

        public RouteScopeObjectFactory(ObjectFactory<?> objectFactory, RouteScopeOwner owner) {
            this.objectFactory = objectFactory;
            this.owner = owner;
        }

        public ObjectWithOwner getObject() throws BeansException {
            return new ObjectWithOwner(this.objectFactory.getObject(), this.owner);
        }

        public RouteScopeOwner getOwner() {
            return this.owner;
        }
    }

    private static class RouteBeanStore
    extends BeanStore
    implements ComponentEventListener<DetachEvent> {
        private UI currentUI;
        private Registration uiDetachRegistration;
        private SerializableConsumer<UI> detachUiCallback;
        private final BeanNamesWrapper beanNames = new BeanNamesWrapper();

        private RouteBeanStore(UI ui, VaadinSession session, SerializableConsumer<UI> detachUiCallback) {
            super(session);
            this.currentUI = ui;
            this.uiDetachRegistration = this.currentUI.addDetachListener((ComponentEventListener)this);
            this.detachUiCallback = detachUiCallback;
        }

        public void onComponentEvent(DetachEvent event) {
            assert (this.getVaadinSession().hasLock());
            this.uiDetachRegistration.remove();
            if (this.resetUI()) {
                this.uiDetachRegistration = this.currentUI.addDetachListener((ComponentEventListener)this);
            } else {
                this.destroy();
                this.detachUiCallback.accept((Object)this.currentUI);
            }
        }

        @Override
        protected Object doGet(String name, ObjectFactory<?> objectFactory) {
            RouteScopeObjectFactory cast = (RouteScopeObjectFactory)objectFactory;
            RouteScopeOwner owner = cast.getOwner();
            if (!this.getNavigationListener().hasNavigationOwner(owner)) {
                assert (owner != null);
                throw new IllegalStateException(String.format("Route owner '%s' instance is not available in the active navigation components chain: the scope defined by the bean '%s' doesn't exist.", owner.value(), name));
            }
            Object object = super.doGet(name, objectFactory);
            if (object instanceof ObjectWithOwner) {
                ObjectWithOwner wrapper = (ObjectWithOwner)object;
                return wrapper.object;
            }
            return object;
        }

        @Override
        protected void storeBean(String name, Object bean) {
            ObjectWithOwner wrapper = (ObjectWithOwner)bean;
            super.storeBean(name, wrapper.object);
            this.getNavigationListener().storeOwner(name, wrapper.owner);
        }

        BeanNamesWrapper getBeanNamesWrapper() {
            return this.beanNames;
        }

        private boolean resetUI() {
            UI ui = VaadinRouteScope.findPreservingUI(this.currentUI);
            if (ui == null) {
                return false;
            }
            this.currentUI = ui;
            return true;
        }

        @NonNull
        private NavigationListener getNavigationListener() {
            NavigationListener navigationListener = (NavigationListener)ComponentUtil.getData((Component)this.currentUI, NavigationListener.class);
            assert (navigationListener != null);
            return navigationListener;
        }
    }

    private static class RouteStoreWrapper
    implements Serializable {
        private final VaadinSession session;
        private final Map<String, RouteBeanStore> routeStores;

        private RouteStoreWrapper(VaadinSession session) {
            assert (session.hasLock());
            this.session = session;
            session.addSessionDestroyListener((SessionDestroyListener & Serializable)event -> this.destroy());
            this.routeStores = new HashMap<String, RouteBeanStore>();
        }

        private RouteBeanStore getBeanStore(UI ui) {
            RouteBeanStore beanStore;
            assert (this.session.hasLock());
            ExtendedClientDetails details = ui.getInternals().getExtendedClientDetails();
            String key = this.getUIStoreKey(ui);
            if (details == null) {
                ui.getPage().retrieveExtendedClientDetails((Page.ExtendedClientDetailsReceiver & Serializable)det -> this.relocateStore(ui, key));
            }
            if ((beanStore = this.routeStores.get(key)) == null) {
                beanStore = new RouteBeanStore(ui, this.session, (SerializableConsumer<UI>)(SerializableConsumer & Serializable)uiInstance -> this.routeStores.remove(this.getUIStoreKey((UI)uiInstance)));
                this.routeStores.put(key, beanStore);
            }
            if (!ui.equals(beanStore.currentUI)) {
                beanStore.currentUI = ui;
            }
            return beanStore;
        }

        private void relocateStore(UI ui, String key) {
            assert (this.session.hasLock());
            RouteBeanStore beanStore = this.routeStores.remove(key);
            if (beanStore == null) {
                LoggerFactory.getLogger(RouteStoreWrapper.class).trace("UI bean store is not found by the initial UI id via the key '" + key + "'.");
                if (this.routeStores.get(this.getUIStoreKey(ui)) == null) {
                    throw new IllegalStateException("UI bean store is not found by the initial UI id via the key '" + key + "' and it's not found by the key '" + this.getUIStoreKey(ui) + "' after relocation.");
                }
            } else {
                this.routeStores.put(this.getUIStoreKey(ui), beanStore);
            }
        }

        private String getUIStoreKey(UI ui) {
            ExtendedClientDetails details = ui.getInternals().getExtendedClientDetails();
            if (details == null) {
                return "uid-" + ui.getUIId();
            }
            return "win-" + VaadinRouteScope.getWindowName(ui);
        }

        private void destroy() {
            this.session.lock();
            try {
                this.session.setAttribute(RouteStoreWrapper.class, null);
                this.routeStores.values().forEach(BeanStore::destroy);
                this.routeStores.clear();
            }
            finally {
                this.session.unlock();
            }
        }
    }

    private record ObjectWithOwner(Object object, RouteScopeOwner owner) {
    }

    private static class BeanNamesWrapper
    implements Serializable {
        private Map<Class<?>, Set<String>> beanNamesByNavigationComponents = new HashMap();

        private BeanNamesWrapper() {
        }
    }

    private static class NavigationListener
    implements BeforeEnterListener,
    AfterNavigationListener,
    ComponentEventListener<DetachEvent>,
    Serializable {
        private Class<?> currentNavigationTarget;
        private List<Class<? extends RouterLayout>> currentLayouts;
        private Registration beforeEnterListener;
        private Registration afterNavigationListener;
        private Registration detachListener;
        private final UI ui;

        private NavigationListener(UI ui) {
            this.beforeEnterListener = ui.addBeforeEnterListener((BeforeEnterListener)this);
            this.afterNavigationListener = ui.addAfterNavigationListener((AfterNavigationListener)this);
            this.detachListener = ui.addDetachListener((ComponentEventListener)this);
            this.ui = ui;
        }

        public void afterNavigation(AfterNavigationEvent event) {
            RouteBeanStore store = VaadinRouteScope.getBeanStoreIfExists(this.ui.getSession());
            if (store == null) {
                assert (this.getBeanNamesByNavigationComponents().isEmpty());
            } else {
                HashMap activeChain = new HashMap();
                event.getActiveChain().stream().map(Object::getClass).forEach(clazz -> this.putIfNotNull(activeChain, (Class<?>)clazz, this.removeBeansByNavigationComponent((Class<?>)clazz)));
                Map<Class<?>, Set<String>> notActiveChain = this.getBeanNamesByNavigationComponents();
                this.setBeanNamesByNavigationComponents(activeChain);
                notActiveChain.values().forEach(names -> names.forEach(store::remove));
            }
        }

        public void beforeEnter(BeforeEnterEvent event) {
            this.currentNavigationTarget = event.getNavigationTarget();
            this.currentLayouts = event.getLayouts();
            RouteBeanStore store = VaadinRouteScope.getBeanStoreIfExists(this.ui.getSession());
            if (store == null) {
                assert (this.getBeanNamesByNavigationComponents().isEmpty());
            } else {
                HashMap activeChain = new HashMap();
                this.putIfNotNull(activeChain, this.currentNavigationTarget, this.removeBeansByNavigationComponent(this.currentNavigationTarget));
                this.currentLayouts.forEach(layoutClass -> this.putIfNotNull(activeChain, (Class<?>)layoutClass, this.removeBeansByNavigationComponent((Class<?>)layoutClass)));
                Map<Class<?>, Set<String>> notActiveChain = this.getBeanNamesByNavigationComponents();
                this.setBeanNamesByNavigationComponents(activeChain);
                notActiveChain.values().forEach(names -> names.forEach(store::remove));
            }
        }

        public void onComponentEvent(DetachEvent event) {
            this.beforeEnterListener.remove();
            this.afterNavigationListener.remove();
            this.detachListener.remove();
        }

        boolean hasNavigationOwner(RouteScopeOwner owner) {
            return owner == null || this.hasOwnerType(this.currentNavigationTarget, owner) || this.layoutsContainsOwner(owner);
        }

        void storeOwner(String name, RouteScopeOwner owner) {
            Class<Object> clazz = owner == null ? this.currentNavigationTarget : owner.value();
            Set set = this.getBeanNamesByNavigationComponents().computeIfAbsent(clazz, key -> new HashSet());
            set.add(name);
        }

        private boolean hasOwnerType(Class<?> clazz, RouteScopeOwner owner) {
            return clazz != null && clazz.equals(owner.value());
        }

        private boolean layoutsContainsOwner(RouteScopeOwner owner) {
            return this.currentLayouts != null && this.currentLayouts.stream().anyMatch(clazz -> this.hasOwnerType((Class<?>)clazz, owner));
        }

        private void putIfNotNull(Map<Class<?>, Set<String>> map, Class<?> key, Set<String> value) {
            if (value != null) {
                map.put(key, value);
            }
        }

        private BeanNamesWrapper getBeanNamesWrapper() {
            RouteBeanStore beanStore = VaadinRouteScope.getBeanStoreIfExists(this.ui.getSession());
            return beanStore == null ? null : beanStore.getBeanNamesWrapper();
        }

        private Map<Class<?>, Set<String>> getBeanNamesByNavigationComponents() {
            BeanNamesWrapper wrapper = this.getBeanNamesWrapper();
            if (wrapper == null) {
                return Collections.emptyMap();
            }
            return wrapper.beanNamesByNavigationComponents;
        }

        private Set<String> removeBeansByNavigationComponent(Class<?> clazz) {
            Map<Class<?>, Set<String>> map = this.getBeanNamesByNavigationComponents();
            if (map.isEmpty()) {
                return null;
            }
            return map.remove(clazz);
        }

        private void setBeanNamesByNavigationComponents(Map<Class<?>, Set<String>> map) {
            BeanNamesWrapper wrapper = this.getBeanNamesWrapper();
            if (wrapper != null) {
                wrapper.beanNamesByNavigationComponents = map;
            }
        }
    }
}

