/*
 * Decompiled with CFR 0.152.
 */
package de.muenchen.oss.wahllokalsystem.wls.common.security;

import de.muenchen.oss.wahllokalsystem.wls.common.security.BezirkIDPermissionEvaluator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component(value="bezirkIdPermisionEvaluator")
@Profile(value={"!dummy.nobezirkid.check"})
public class BezirkIDPermissionEvaluatorImpl
implements BezirkIDPermissionEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(BezirkIDPermissionEvaluatorImpl.class);
    private static final String AUTH_DETAILS_MAP_KEY_WAHLBEZIRK_ID = "wahlbezirkID";
    private static final String AUTH_DETAILS_MAP_KEY_WAHLBEZIRKID_WAHLNUMMER = "wahlbezirkid_wahlnummer";

    @Override
    public boolean tokenUserBezirkIdMatches(String bezirkId, Authentication auth) {
        if (auth == null) {
            LOG.warn("No authentication object for bezirkId={}", (Object)bezirkId);
            return false;
        }
        LOG.debug("tokenUserBezirkIdMatches {}, {}", (Object)bezirkId, auth.getPrincipal());
        try {
            String bezirkIDFromToken = this.getBezirkID(auth);
            String wahlbezirkid_wahlnummer = this.getWahlbezirkid_wahlnummer(auth);
            boolean bezirkIdMatches = bezirkId != null && (bezirkId.equals(bezirkIDFromToken) || wahlbezirkid_wahlnummer != null && wahlbezirkid_wahlnummer.contains(bezirkId));
            LOG.debug("Check bezirkId {} from request against username {}, bezirkId {} from token or wahlbezirkid_wahlnummer {}. RESULT = {}", new Object[]{bezirkId, auth.getPrincipal(), bezirkIDFromToken, wahlbezirkid_wahlnummer, bezirkIdMatches});
            return bezirkIdMatches;
        }
        catch (Exception e) {
            LOG.error("Error while checking bezirkId.", (Throwable)e);
            return false;
        }
    }

    private String getBezirkID(Authentication auth) {
        Map details = (Map)auth.getDetails();
        return (String)details.get(AUTH_DETAILS_MAP_KEY_WAHLBEZIRK_ID);
    }

    private String getWahlbezirkid_wahlnummer(Authentication auth) {
        Map details = (Map)auth.getDetails();
        return (String)details.get(AUTH_DETAILS_MAP_KEY_WAHLBEZIRKID_WAHLNUMMER);
    }
}

