/*
 * Decompiled with CFR 0.152.
 */
package de.muenchen.oss.wahllokalsystem.wls.common.security;

import de.muenchen.oss.wahllokalsystem.wls.common.exception.TechnischeWlsException;
import de.muenchen.oss.wahllokalsystem.wls.common.exception.util.ServiceIDFormatter;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptionBuilder {
    private static final Logger log = LoggerFactory.getLogger(EncryptionBuilder.class);
    private static ServiceIDFormatter formatter;
    private static final String AES = "AES";
    private final Cipher _encryptCipher;
    private final Cipher _decryptCipher;
    private static final String technischeExceptionKonstante = "S";

    public EncryptionBuilder(byte[] aSecret, ServiceIDFormatter formatter) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        SecretKeySpec secret = new SecretKeySpec(aSecret, 0, 16, AES);
        EncryptionBuilder.formatter = formatter;
        this._encryptCipher = Cipher.getInstance(AES);
        this._encryptCipher.init(1, secret);
        this._decryptCipher = Cipher.getInstance(AES);
        this._decryptCipher.init(2, secret);
    }

    public String decryptValue(String value) {
        if (value != null && !value.isEmpty()) {
            try {
                byte[] decode = Base64.getUrlDecoder().decode(value.getBytes());
                byte[] finalized = this._decryptCipher.doFinal(decode);
                return new String(finalized);
            }
            catch (BadPaddingException | IllegalBlockSizeException e) {
                log.error("Unable to decrypt the given value <" + value + "> as of an " + e.getClass().getSimpleName() + ". Using direct object reference!", (Throwable)e);
                throw (TechnischeWlsException)TechnischeWlsException.withCode((String)technischeExceptionKonstante).inService(formatter.getId()).buildWithMessage("Problem bei Referenzierung/Dereferenzierung von Objekt-Referenzen");
            }
        }
        return value;
    }

    public String encryptValue(String value) {
        if (value != null && !value.isEmpty()) {
            try {
                byte[] finalized = this._encryptCipher.doFinal(value.getBytes());
                value = Base64.getUrlEncoder().encodeToString(finalized);
            }
            catch (BadPaddingException | IllegalBlockSizeException e) {
                log.error("Unable to encrypt the given value <" + value + "> as of an " + e.getClass().getSimpleName() + ". Using direct object reference!", (Throwable)e);
                throw (TechnischeWlsException)TechnischeWlsException.withCode((String)technischeExceptionKonstante).inService(formatter.getId()).buildWithMessage("Problem bei Referenzierung/Dereferenzierung von Objekt-Referenzen");
            }
        }
        return value;
    }
}

