/*
 * Copyright (C) Red Gate Software Ltd 2010-2021
 * Copyright 2022-2024 The MigrateDB contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package migratedb.v1.core.internal.database.sqlite;

import migratedb.v1.core.internal.database.base.BaseSession;

import java.sql.Connection;

public class SQLiteSession extends BaseSession {
    SQLiteSession(SQLiteDatabase database, Connection connection) {
        super(database, connection);
    }

    @Override
    public SQLiteSchema getSchema(String name) {
        return new SQLiteSchema(jdbcTemplate, getDatabase(), name);
    }

    @Override
    public SQLiteDatabase getDatabase() {
        return (SQLiteDatabase) super.getDatabase();
    }

    @Override
    protected String getCurrentSchemaNameOrSearchPath() {
        return "main";
    }
}
