/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.boot.felix;

import dev.galasa.boot.BootLogger;
import dev.galasa.boot.LauncherException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.felix.bundlerepository.Capability;
import org.apache.felix.bundlerepository.Reason;
import org.apache.felix.bundlerepository.Repository;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.apache.felix.bundlerepository.Requirement;
import org.apache.felix.bundlerepository.Resolver;
import org.apache.felix.bundlerepository.Resource;
import org.apache.felix.framework.FrameworkFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.launch.Framework;

public class FelixFramework {
    private BootLogger logger = new BootLogger();
    private boolean loadConsole = false;
    private String bootJarLoacation = null;
    private Framework framework;
    private Bundle obrBundle;
    private RepositoryAdmin repositoryAdmin;
    private final SecureRandom random = new SecureRandom();
    private File felixCache;

    public void buildFramework(List<String> bundleRepositories, Properties boostrapProperties, URL localMavenRepo, List<URL> remoteMavenRepos) throws LauncherException, ClassNotFoundException {
        this.logger.debug("Building Felix Framework...");
        String felixCacheDirectory = System.getProperty("user.home");
        File galasaDirectory = new File(felixCacheDirectory, ".galasa");
        String cacheDirectory = "felix-cache";
        this.felixCache = new File(galasaDirectory, cacheDirectory);
        try {
            FileUtils.deleteDirectory(this.felixCache);
            this.felixCache.mkdirs();
            FrameworkFactory frameworkFactory = new FrameworkFactory();
            HashMap<String, String> frameworkProperties = new HashMap<String, String>();
            frameworkProperties.put("org.osgi.framework.storage", this.felixCache.getAbsolutePath());
            frameworkProperties.put("org.osgi.framework.storage.clean", "onFirstInit");
            frameworkProperties.put("org.osgi.framework.system.packages.extra", "org.apache.felix.bundlerepository; version=2.1, dev.galasa.framework, sun.misc, com.sun.net.httpserver, com.sun.management, org.xml.sax, sun.nio.ch");
            this.framework = frameworkFactory.newFramework(frameworkProperties);
            this.logger.debug("Initializing Felix Framework");
            this.framework.init();
            this.logger.debug("Starting Felix Framework");
            this.framework.start();
            this.logger.debug("Felix Framework started");
            this.logger.debug("Installing required OSGi bundles");
            this.bootJarLoacation = boostrapProperties.getProperty("dev.galasa.boot.jar.location");
            this.installBundle("org.apache.felix.scr.jar", true);
            this.installBundle("dev.galasa.framework.log4j2.bridge.jar", false);
            this.installBundle("log4j-api.jar", true);
            this.installBundle("log4j-core.jar", true);
            this.installBundle("dev.galasa.framework.maven.repository.spi.jar", true);
            this.installBundle("dev.galasa.framework.maven.repository.jar", true);
            this.loadMavenRepositories(localMavenRepo, remoteMavenRepos);
            this.obrBundle = this.installBundle("org.apache.felix.bundlerepository.jar", true);
            this.loadBundleRepositories(bundleRepositories);
            this.loadConsole = Boolean.parseBoolean(boostrapProperties.getProperty("dev.galasa.core.load.console", "false"));
            if (this.loadConsole) {
                this.loadBundle("org.apache.felix.gogo.runtime");
                this.loadBundle("org.apache.felix.gogo.command");
                this.loadBundle("org.apache.felix.gogo.shell");
            }
            this.logger.debug("installing Framework bundle");
            this.loadBundle("dev.galasa.framework");
            String extraBundles = boostrapProperties.getProperty("framework.extra.bundles");
            if (extraBundles != null) {
                String[] ebs;
                for (String eb : ebs = extraBundles.split(",")) {
                    if ((eb = eb.trim()).isEmpty()) continue;
                    this.loadBundle(eb);
                }
            }
        }
        catch (IOException | BundleException e) {
            throw new LauncherException("Unable to initialise the Felix framework", e);
        }
    }

    private void loadMavenRepositories(URL localMavenRepo, List<URL> remoteMavenRepos) throws LauncherException {
        Method runTestMethod;
        ServiceReference<?>[] serviceReferences;
        Bundle frameWorkBundle = this.getBundle("dev.galasa.framework.maven.repository");
        String classString = "dev.galasa.framework.maven.repository.spi.IMavenRepository";
        try {
            serviceReferences = frameWorkBundle.getBundleContext().getServiceReferences(classString, null);
        }
        catch (InvalidSyntaxException e) {
            throw new LauncherException("Unable to get framework service reference", e);
        }
        if (serviceReferences == null || serviceReferences.length != 1) {
            throw new LauncherException("Unable to get single reference to GalasaMavenRepository service: " + (serviceReferences == null ? 0 : serviceReferences.length) + " service(s) returned");
        }
        Object service = frameWorkBundle.getBundleContext().getService(serviceReferences[0]);
        if (service == null) {
            throw new LauncherException("Unable to get GalasaMavenRepository service");
        }
        try {
            runTestMethod = service.getClass().getMethod("setRepositories", URL.class, List.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new LauncherException("Unable to get Framework Maven Repository method", e);
        }
        try {
            runTestMethod.invoke(service, localMavenRepo, remoteMavenRepos);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new LauncherException(e.getCause());
        }
    }

    public void runTest(Properties boostrapProperties, Properties overridesProperties) throws LauncherException {
        Method runTestMethod;
        ServiceReference<?>[] serviceReferences;
        Bundle frameWorkBundle = this.getBundle("dev.galasa.framework");
        String classString = "dev.galasa.framework.TestRunner";
        if (overridesProperties.containsKey("framework.run.gherkintest")) {
            classString = "dev.galasa.framework.GherkinTestRunner";
        }
        String filterString = "(objectClass=" + classString + ")";
        try {
            serviceReferences = frameWorkBundle.getBundleContext().getServiceReferences(classString, filterString);
        }
        catch (InvalidSyntaxException e) {
            throw new LauncherException("Unable to get framework service reference", e);
        }
        if (serviceReferences == null || serviceReferences.length != 1) {
            throw new LauncherException("Unable to get single reference to TestRunner service: " + (serviceReferences == null ? 0 : serviceReferences.length) + " service(s) returned");
        }
        Object service = frameWorkBundle.getBundleContext().getService(serviceReferences[0]);
        if (service == null) {
            throw new LauncherException("Unable to get TestRunner service");
        }
        try {
            runTestMethod = service.getClass().getMethod("runTest", Properties.class, Properties.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new LauncherException("Unable to get Framework test runner method", e);
        }
        this.logger.debug("Invoking runTest()");
        try {
            runTestMethod.invoke(service, boostrapProperties, overridesProperties);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new LauncherException(e.getCause());
        }
    }

    public void runResourceManagement(Properties boostrapProperties, Properties overridesProperties, List<String> bundles, Integer metrics, Integer health) throws LauncherException {
        Method runTestMethod;
        ServiceReference<?>[] serviceReferences;
        Bundle frameWorkBundle = this.getBundle("dev.galasa.framework");
        if (!bundles.isEmpty()) {
            for (String string : bundles) {
                try {
                    this.loadBundle(string);
                }
                catch (Exception e) {
                    throw new LauncherException("Failed to load extra bundle " + string, e);
                }
            }
        } else {
            HashSet<String> bundlesToLoad = new HashSet<String>();
            for (Repository repository : this.repositoryAdmin.listRepositories()) {
                if (repository.getResources() == null) continue;
                block10: for (Resource resource : repository.getResources()) {
                    if (resource.getCapabilities() == null) continue;
                    for (Capability capability : resource.getCapabilities()) {
                        String[] split;
                        if (!"service".equals(capability.getName())) continue;
                        Map<String, Object> properties = capability.getPropertiesAsMap();
                        String services = (String)properties.get("objectClass");
                        if (services == null) {
                            services = (String)properties.get("objectClass:List<String>");
                        }
                        if (services == null) continue;
                        for (String service : split = services.split(",")) {
                            if (!"dev.galasa.framework.spi.IResourceManagementProvider".equals(service)) continue;
                            bundlesToLoad.add(resource.getSymbolicName());
                            continue block10;
                        }
                    }
                }
            }
            for (String bundle : bundlesToLoad) {
                if (this.isBundleActive(bundle)) continue;
                this.loadBundle(bundle);
            }
        }
        if (metrics != null) {
            overridesProperties.put("framework.resource.management.metrics.port", metrics.toString());
        }
        if (health != null) {
            overridesProperties.put("framework.resource.management.health.port", health.toString());
        }
        String classString = "dev.galasa.framework.resource.management.internal.ResourceManagement";
        String string = "(objectClass=" + classString + ")";
        try {
            serviceReferences = frameWorkBundle.getBundleContext().getServiceReferences(classString, string);
        }
        catch (InvalidSyntaxException e) {
            throw new LauncherException("Unable to get framework service reference", e);
        }
        if (serviceReferences == null || serviceReferences.length != 1) {
            throw new LauncherException("Unable to get single reference to ResourceManagement service: " + (serviceReferences == null ? 0 : serviceReferences.length) + " service(s) returned");
        }
        Object service = frameWorkBundle.getBundleContext().getService(serviceReferences[0]);
        if (service == null) {
            throw new LauncherException("Unable to get ResourceManagement service");
        }
        try {
            runTestMethod = service.getClass().getMethod("run", Properties.class, Properties.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new LauncherException("Unable to get Framework resource management run method", e);
        }
        this.logger.debug("Invoking resource management run()");
        try {
            runTestMethod.invoke(service, boostrapProperties, overridesProperties);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new LauncherException(e.getCause());
        }
    }

    public void runMetricsServer(Properties boostrapProperties, Properties overridesProperties, List<String> bundles, Integer metrics, Integer health) throws LauncherException {
        Method runTestMethod;
        ServiceReference<?>[] serviceReferences;
        Bundle frameWorkBundle = this.getBundle("dev.galasa.framework");
        if (!bundles.isEmpty()) {
            for (String string : bundles) {
                try {
                    this.loadBundle(string);
                }
                catch (Exception e) {
                    throw new LauncherException("Failed to load extra bundle " + string, e);
                }
            }
        } else {
            HashSet<String> bundlesToLoad = new HashSet<String>();
            for (Repository repository : this.repositoryAdmin.listRepositories()) {
                if (repository.getResources() == null) continue;
                block10: for (Resource resource : repository.getResources()) {
                    if (resource.getCapabilities() == null) continue;
                    for (Capability capability : resource.getCapabilities()) {
                        String[] split;
                        if (!"service".equals(capability.getName())) continue;
                        Map<String, Object> properties = capability.getPropertiesAsMap();
                        String services = (String)properties.get("objectClass");
                        if (services == null) {
                            services = (String)properties.get("objectClass:List<String>");
                        }
                        if (services == null) continue;
                        for (String service : split = services.split(",")) {
                            if (!"dev.galasa.framework.spi.IMetricsProvider".equals(service)) continue;
                            bundlesToLoad.add(resource.getSymbolicName());
                            continue block10;
                        }
                    }
                }
            }
            for (String bundle : bundlesToLoad) {
                if (this.isBundleActive(bundle)) continue;
                this.loadBundle(bundle);
            }
        }
        if (metrics != null) {
            overridesProperties.put("framework.metrics.port", metrics.toString());
        }
        if (health != null) {
            overridesProperties.put("framework.metrics.health.port", health.toString());
        }
        String classString = "dev.galasa.framework.metrics.MetricsServer";
        String string = "(objectClass=" + classString + ")";
        try {
            serviceReferences = frameWorkBundle.getBundleContext().getServiceReferences(classString, string);
        }
        catch (InvalidSyntaxException e) {
            throw new LauncherException("Unable to get framework service reference", e);
        }
        if (serviceReferences == null || serviceReferences.length != 1) {
            throw new LauncherException("Unable to get single reference to MetricsServer service: " + (serviceReferences == null ? 0 : serviceReferences.length) + " service(s) returned");
        }
        Object service = frameWorkBundle.getBundleContext().getService(serviceReferences[0]);
        if (service == null) {
            throw new LauncherException("Unable to get MetricsServer service");
        }
        try {
            runTestMethod = service.getClass().getMethod("run", Properties.class, Properties.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new LauncherException("Unable to get Framework MetricsServer run method", e);
        }
        this.logger.debug("Invoking MetricsServer run()");
        try {
            runTestMethod.invoke(service, boostrapProperties, overridesProperties);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new LauncherException(e.getCause());
        }
    }

    public void runBackupCPS(Properties boostrapProperties, Properties overridesProperties, String filePath) throws LauncherException {
        Method runBackupCPSMethod;
        ServiceReference<?>[] serviceReferences;
        Bundle frameWorkBundle = this.getBundle("dev.galasa.framework");
        String classString = "dev.galasa.framework.BackupCPS";
        String filterString = "(objectClass=" + classString + ")";
        try {
            serviceReferences = frameWorkBundle.getBundleContext().getServiceReferences(classString, filterString);
        }
        catch (InvalidSyntaxException e) {
            throw new LauncherException("Unable to get framework service reference", e);
        }
        if (serviceReferences == null || serviceReferences.length != 1) {
            throw new LauncherException("Unable to get single reference to BackupCPS service: " + (serviceReferences == null ? 0 : serviceReferences.length) + " service(s) returned");
        }
        Object service = frameWorkBundle.getBundleContext().getService(serviceReferences[0]);
        if (service == null) {
            throw new LauncherException("Unable to get BackupCPS service");
        }
        try {
            runBackupCPSMethod = service.getClass().getMethod("backup", Properties.class, Properties.class, String.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new LauncherException("Unable to get Framework BackupCPS backup method", e);
        }
        this.logger.debug("Invoking BackupCPS backup()");
        try {
            runBackupCPSMethod.invoke(service, boostrapProperties, overridesProperties, filePath);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new LauncherException(e.getCause());
        }
    }

    public void runRestoreCPS(Properties boostrapProperties, Properties overridesProperties, String filePath, boolean dryRun) throws LauncherException {
        Method runRestoreCPSMethod;
        ServiceReference<?>[] serviceReferences;
        Bundle frameWorkBundle = this.getBundle("dev.galasa.framework");
        String className = "RestoreCPS";
        String methodName = "restore";
        String classString = "dev.galasa.framework." + className;
        String filterString = "(objectClass=" + classString + ")";
        try {
            serviceReferences = frameWorkBundle.getBundleContext().getServiceReferences(classString, filterString);
        }
        catch (InvalidSyntaxException e) {
            throw new LauncherException("Unable to get framework service reference", e);
        }
        if (serviceReferences == null || serviceReferences.length != 1) {
            throw new LauncherException("Unable to get single reference to " + className + " service: " + (serviceReferences == null ? 0 : serviceReferences.length) + " service(s) returned");
        }
        Object service = frameWorkBundle.getBundleContext().getService(serviceReferences[0]);
        if (service == null) {
            throw new LauncherException("Unable to get " + className + " service");
        }
        try {
            runRestoreCPSMethod = service.getClass().getMethod(methodName, Properties.class, Properties.class, String.class, Boolean.TYPE);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new LauncherException("Unable to get Framework " + className + " " + methodName + " method", e);
        }
        this.logger.debug("Invoking " + className + " " + methodName + "()");
        try {
            runRestoreCPSMethod.invoke(service, boostrapProperties, overridesProperties, filePath, dryRun);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new LauncherException(e.getCause());
        }
    }

    public void runSetupEcosystem(Properties boostrapProperties, Properties overridesProperties) throws LauncherException {
        Method runSetupMethod;
        ServiceReference<?>[] serviceReferences;
        Bundle frameWorkBundle = this.getBundle("dev.galasa.framework");
        String classString = "dev.galasa.framework.SetupEcosystem";
        String filterString = "(objectClass=" + classString + ")";
        try {
            serviceReferences = frameWorkBundle.getBundleContext().getServiceReferences(classString, filterString);
        }
        catch (InvalidSyntaxException e) {
            throw new LauncherException("Unable to get framework service reference", e);
        }
        if (serviceReferences == null || serviceReferences.length != 1) {
            throw new LauncherException("Unable to get single reference to SetupEcosystem service: " + (serviceReferences == null ? 0 : serviceReferences.length) + " service(s) returned");
        }
        Object service = frameWorkBundle.getBundleContext().getService(serviceReferences[0]);
        if (service == null) {
            throw new LauncherException("Unable to get SetupEcosystem service");
        }
        try {
            runSetupMethod = service.getClass().getMethod("setup", Properties.class, Properties.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new LauncherException("Unable to get Framework SetupEcosystem setup method", e);
        }
        this.logger.debug("Invoking SetupEcosystem setup()");
        try {
            runSetupMethod.invoke(service, boostrapProperties, overridesProperties);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new LauncherException(e.getCause());
        }
    }

    public void runValidateEcosystem(Properties boostrapProperties, Properties overridesProperties) throws LauncherException {
        Method runSetupMethod;
        ServiceReference<?>[] serviceReferences;
        Bundle frameWorkBundle = this.getBundle("dev.galasa.framework");
        String classString = "dev.galasa.framework.ValidateEcosystem";
        String filterString = "(objectClass=" + classString + ")";
        try {
            serviceReferences = frameWorkBundle.getBundleContext().getServiceReferences(classString, filterString);
        }
        catch (InvalidSyntaxException e) {
            throw new LauncherException("Unable to get framework service reference", e);
        }
        if (serviceReferences == null || serviceReferences.length != 1) {
            throw new LauncherException("Unable to get single reference to SetupEcosystem service: " + (serviceReferences == null ? 0 : serviceReferences.length) + " service(s) returned");
        }
        Object service = frameWorkBundle.getBundleContext().getService(serviceReferences[0]);
        if (service == null) {
            throw new LauncherException("Unable to get SetupEcosystem service");
        }
        try {
            runSetupMethod = service.getClass().getMethod("setup", Properties.class, Properties.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new LauncherException("Unable to get Framework SetupEcosystem setup method", e);
        }
        this.logger.debug("Invoking SetupEcosystem setup()");
        try {
            runSetupMethod.invoke(service, boostrapProperties, overridesProperties);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new LauncherException(e.getCause());
        }
    }

    public void runWebApiServer(Properties boostrapProperties, Properties overridesProperties, List<String> bundles, Integer metrics, Integer health) throws LauncherException {
        Method runTestMethod;
        ServiceReference<?>[] serviceReferences;
        this.loadBundle("org.apache.felix.http.servlet-api");
        this.loadBundle("org.apache.felix.http.jetty");
        this.loadBundle("org.apache.felix.fileinstall");
        Bundle frameWorkBundle = this.getBundle("dev.galasa.framework");
        this.loadBundle("dev.galasa.framework.api");
        String classString = "dev.galasa.framework.api.internal.ApiStartup";
        String filterString = "(objectClass=" + classString + ")";
        try {
            serviceReferences = frameWorkBundle.getBundleContext().getServiceReferences(classString, filterString);
        }
        catch (InvalidSyntaxException e) {
            throw new LauncherException("Unable to get framework service reference", e);
        }
        if (serviceReferences == null || serviceReferences.length != 1) {
            throw new LauncherException("Unable to get single reference to ApiStartup service: " + (serviceReferences == null ? 0 : serviceReferences.length) + " service(s) returned");
        }
        Object service = frameWorkBundle.getBundleContext().getService(serviceReferences[0]);
        if (service == null) {
            throw new LauncherException("Unable to get ApiStartup service");
        }
        try {
            runTestMethod = service.getClass().getMethod("run", Properties.class, Properties.class, List.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new LauncherException("Unable to get Framework ApiStartup run method", e);
        }
        this.logger.debug("Invoking ApiStartup run()");
        try {
            runTestMethod.invoke(service, boostrapProperties, overridesProperties, bundles);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new LauncherException(e.getCause());
        }
    }

    public void runK8sController(Properties boostrapProperties, Properties overridesProperties, List<String> bundles, Integer metrics, Integer health) throws LauncherException {
        Method runTestMethod;
        ServiceReference<?>[] serviceReferences;
        Bundle frameWorkBundle = this.getBundle("dev.galasa.framework");
        this.loadBundle("dev.galasa.framework.k8s.controller");
        if (metrics != null) {
            overridesProperties.put("framework.controller.metrics.port", metrics.toString());
        }
        if (health != null) {
            overridesProperties.put("framework.controller.health.port", health.toString());
        }
        String classString = "dev.galasa.framework.k8s.controller.K8sController";
        String filterString = "(objectClass=" + classString + ")";
        try {
            serviceReferences = frameWorkBundle.getBundleContext().getServiceReferences(classString, filterString);
        }
        catch (InvalidSyntaxException e) {
            throw new LauncherException("Unable to get framework service reference", e);
        }
        if (serviceReferences == null || serviceReferences.length != 1) {
            throw new LauncherException("Unable to get single reference to K8sController service: " + (serviceReferences == null ? 0 : serviceReferences.length) + " service(s) returned");
        }
        Object service = frameWorkBundle.getBundleContext().getService(serviceReferences[0]);
        if (service == null) {
            throw new LauncherException("Unable to get K8sController service");
        }
        try {
            runTestMethod = service.getClass().getMethod("run", Properties.class, Properties.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new LauncherException("Unable to get K8sController run method", e);
        }
        this.logger.debug("Invoking k8s controller run()");
        try {
            runTestMethod.invoke(service, boostrapProperties, overridesProperties);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new LauncherException(e.getCause());
        }
    }

    public void runDockerController(Properties boostrapProperties, Properties overridesProperties, List<String> bundles, Integer metrics, Integer health) throws LauncherException {
        Method runTestMethod;
        ServiceReference<?>[] serviceReferences;
        Bundle frameWorkBundle = this.getBundle("dev.galasa.framework");
        this.loadBundle("dev.galasa.framework.docker.controller");
        if (metrics != null) {
            overridesProperties.put("framework.controller.metrics.port", metrics.toString());
        }
        if (health != null) {
            overridesProperties.put("framework.controller.health.port", health.toString());
        }
        String classString = "dev.galasa.framework.docker.controller.DockerController";
        String filterString = "(objectClass=" + classString + ")";
        try {
            serviceReferences = frameWorkBundle.getBundleContext().getServiceReferences(classString, filterString);
        }
        catch (InvalidSyntaxException e) {
            throw new LauncherException("Unable to get framework service reference", e);
        }
        if (serviceReferences == null || serviceReferences.length != 1) {
            throw new LauncherException("Unable to get single reference to DockerController service: " + (serviceReferences == null ? 0 : serviceReferences.length) + " service(s) returned");
        }
        Object service = frameWorkBundle.getBundleContext().getService(serviceReferences[0]);
        if (service == null) {
            throw new LauncherException("Unable to get DockerController service");
        }
        try {
            runTestMethod = service.getClass().getMethod("run", Properties.class, Properties.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new LauncherException("Unable to get DockerController run method", e);
        }
        this.logger.debug("Invoking Docker controller run()");
        try {
            runTestMethod.invoke(service, boostrapProperties, overridesProperties);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new LauncherException(e.getCause());
        }
    }

    public void stopFramework() throws LauncherException, InterruptedException {
        this.logger.debug("Stopping Felix framework");
        if (this.framework == null) {
            return;
        }
        try {
            this.framework.stop();
        }
        catch (BundleException e) {
            throw new LauncherException("Unable to stop the Felix framework", e);
        }
        this.framework.waitForStop(30000L);
        this.logger.debug("Felix framework stopped");
        try {
            FileUtils.deleteDirectory(this.felixCache);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void loadBundleRepositories(List<String> bundleRepositories) throws LauncherException {
        ServiceReference<?> serviceReference = this.obrBundle.getBundleContext().getServiceReference(RepositoryAdmin.class.getName());
        if (serviceReference == null) {
            throw new LauncherException("Unable to get OBR RepositoryAdmin service");
        }
        this.repositoryAdmin = (RepositoryAdmin)this.obrBundle.getBundleContext().getService(serviceReference);
        for (String bundleRepository : bundleRepositories) {
            Repository repository;
            this.logger.trace("Loading OBR OSGi Bundle Repository " + bundleRepository);
            try {
                repository = this.repositoryAdmin.addRepository(bundleRepository);
            }
            catch (Exception e) {
                throw new LauncherException("Unable to load repository " + bundleRepository, e);
            }
            if (!this.logger.isTraceEnabled()) continue;
            this.logger.trace("Loaded repository " + repository.getName() + " from URI " + repository.getURI());
            Resource[] resources = repository.getResources();
            String sp3 = "   ";
            for (Resource resource : resources) {
                Requirement[] requirements;
                this.logger.trace(sp3 + resource.getId());
                this.logger.trace(sp3 + sp3 + resource.getURI());
                this.logger.trace(sp3 + sp3 + resource.getSymbolicName());
                this.logger.trace(sp3 + sp3 + resource.getPresentationName());
                this.logger.trace(sp3 + sp3 + "requirements:");
                for (Requirement requirement : requirements = resource.getRequirements()) {
                    this.logger.trace("        " + requirement.getFilter() + " optional=" + requirement.isOptional());
                }
            }
        }
    }

    private void loadBundle(String bundleSymbolicName) throws LauncherException {
        this.logger.trace("Installing bundle " + bundleSymbolicName);
        Resolver resolver = this.repositoryAdmin.resolver();
        String filterString = "(symbolicname=" + bundleSymbolicName + ")";
        Resource[] resources = null;
        try {
            resources = this.repositoryAdmin.discoverResources(filterString);
        }
        catch (InvalidSyntaxException e) {
            throw new LauncherException("Unable to discover repoistory resources", e);
        }
        try {
            if (resources.length == 0) {
                throw new LauncherException("Unable to locate bundle \"" + bundleSymbolicName + "\" in OBR repository");
            }
            this.addResource(bundleSymbolicName, resolver, resources[0]);
        }
        catch (LauncherException e) {
            throw new LauncherException("Unable to install bundle \"" + bundleSymbolicName + "\" from OBR repository", e);
        }
    }

    private void addResource(String bundleSymbolicName, Resolver resolver, Resource resource) throws LauncherException {
        this.logger.trace("Resouce: " + resource);
        resolver.add(resource);
        boolean resourceHasReferenceUrl = false;
        if (resource.getURI().startsWith("reference:")) {
            resourceHasReferenceUrl = true;
        }
        if (resolver.resolve()) {
            Resource[] optionalResources;
            Resource[] requiredResources;
            for (Resource requiredResource : requiredResources = resolver.getRequiredResources()) {
                if (requiredResource.getURI().startsWith("reference:")) {
                    resourceHasReferenceUrl = true;
                }
                if (!this.logger.isTraceEnabled()) continue;
                this.logger.trace("  RequiredResource: " + requiredResource.getSymbolicName());
            }
            for (Resource optionalResource : optionalResources = resolver.getOptionalResources()) {
                if (optionalResource.getURI().startsWith("reference:")) {
                    resourceHasReferenceUrl = true;
                }
                if (!this.logger.isTraceEnabled()) continue;
                this.logger.trace("  OptionalResource: " + optionalResource.getSymbolicName());
            }
            if (!resourceHasReferenceUrl) {
                resolver.deploy(16);
            } else {
                ArrayList<Bundle> bundlesToStart = new ArrayList<Bundle>();
                try {
                    Resource[] startRequiredResources;
                    for (Resource requiredResource : startRequiredResources = resolver.getRequiredResources()) {
                        bundlesToStart.add(this.framework.getBundleContext().installBundle(requiredResource.getURI().toString()));
                    }
                    Resource[] startOptionalResources = resolver.getOptionalResources();
                    for (Resource optionalResource : startOptionalResources) {
                        bundlesToStart.add(this.framework.getBundleContext().installBundle(optionalResource.getURI().toString()));
                    }
                    bundlesToStart.add(this.framework.getBundleContext().installBundle(resource.getURI().toString()));
                    for (Bundle bundle : bundlesToStart) {
                        bundle.start();
                    }
                }
                catch (Exception e) {
                    throw new LauncherException("Unable to install bundles outside of resolver", e);
                }
            }
            if (!this.isBundleActive(bundleSymbolicName)) {
                throw new LauncherException("Bundle failed to install and activate");
            }
        } else {
            Reason[] unsatisfiedRequirements;
            this.logger.error("Unable to resolve " + resource.toString());
            for (Reason reason : unsatisfiedRequirements = resolver.getUnsatisfiedRequirements()) {
                this.logger.error("Unsatisfied requirement: " + reason.getRequirement());
            }
            throw new LauncherException("Unable to resolve bundle " + bundleSymbolicName);
        }
        this.printBundles();
    }

    private Bundle getBundle(String bundleSymbolicName) throws LauncherException {
        Bundle[] bundles;
        for (Bundle bundle : bundles = this.framework.getBundleContext().getBundles()) {
            if (!bundle.getSymbolicName().contentEquals(bundleSymbolicName)) continue;
            return bundle;
        }
        throw new LauncherException("Unable to find bundle with Bundle-SymbolicName=" + bundleSymbolicName);
    }

    private Bundle installBundle(String bundleJar, boolean start) throws LauncherException, BundleException {
        Object bundleLocation = null;
        bundleLocation = this.isJar() ? this.getClass().getClassLoader().getResource("bundle/" + bundleJar).toExternalForm() : "jar:file:/" + this.bootJarLoacation + "!/bundle/" + bundleJar;
        this.logger.trace("bundleLocation: " + (String)bundleLocation);
        Bundle bundle = this.framework.getBundleContext().installBundle((String)bundleLocation);
        if (start) {
            bundle.start();
        }
        this.printBundles();
        return bundle;
    }

    private boolean isJar() throws LauncherException {
        URL resourceURL = this.getClass().getClassLoader().getResource("");
        if (resourceURL == null) {
            resourceURL = this.getClass().getResource("");
        }
        if (resourceURL == null) {
            throw new LauncherException("Unable to determine if running from a jar file");
        }
        this.logger.trace("isJar resource URL protocol: " + resourceURL.getProtocol());
        return Objects.equals(resourceURL.getProtocol(), "jar");
    }

    private boolean isBundleActive(String bundleSymbolicName) {
        Bundle[] bundles;
        for (Bundle bundle : bundles = this.framework.getBundleContext().getBundles()) {
            if (!bundle.getSymbolicName().equals(bundleSymbolicName) || bundle.getState() != 32) continue;
            return true;
        }
        return false;
    }

    private void printBundles() {
        if (!this.logger.isTraceEnabled()) {
            return;
        }
        Bundle[] bundles = this.framework.getBundleContext().getBundles();
        StringBuilder messageBuffer = new StringBuilder(2048);
        messageBuffer.append("Bundle status:");
        for (Bundle bundle : bundles) {
            Object gitHash;
            block10: {
                gitHash = "";
                try {
                    URL githashUrl = bundle.getEntry("/META-INF/git.hash");
                    if (githashUrl == null) break block10;
                    try (InputStream is = githashUrl.openStream();){
                        gitHash = "-" + IOUtils.toString(is, StandardCharsets.UTF_8);
                    }
                }
                catch (Exception githashUrl) {
                    // empty catch block
                }
            }
            String bundleId = String.valueOf(bundle.getBundleId());
            messageBuffer.append("\n").append(String.format("%5s", bundleId)).append("|").append(String.format("%-11s", this.getBundleStateLabel(bundle))).append("|     |").append(bundle.getSymbolicName()).append(" (").append(bundle.getVersion()).append((String)gitHash).append(")");
        }
        this.logger.trace(messageBuffer.toString());
    }

    private String getBundleStateLabel(Bundle bundle) {
        switch (bundle.getState()) {
            case 1: {
                return "Uninstalled";
            }
            case 2: {
                return "Installed";
            }
            case 4: {
                return "Resolved";
            }
            case 8: {
                return "Starting";
            }
            case 16: {
                return "Stopping";
            }
            case 32: {
                return "Active";
            }
        }
        return "<Unknown (" + bundle.getState() + ")>";
    }
}

