/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundlerepository.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.bundlerepository.Capability;
import org.apache.felix.bundlerepository.impl.NamespaceTranslator;
import org.osgi.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FelixCapabilityAdapter
implements org.osgi.resource.Capability {
    private final Capability capability;
    private final Resource resource;
    private volatile Map<String, Object> convertedAttributes;

    public FelixCapabilityAdapter(Capability capability, Resource resource) {
        if (capability == null) {
            throw new NullPointerException("Missing required parameter: capability");
        }
        this.capability = capability;
        this.resource = resource;
    }

    @Override
    public Map<String, Object> getAttributes() {
        if (this.convertedAttributes == null) {
            org.osgi.resource.Capability bundleCap;
            Map<String, Object> orgMap = this.capability.getPropertiesAsMap();
            HashMap<String, Object> converted = new HashMap<String, Object>(orgMap.size() + 2);
            for (Map.Entry<String, Object> entry : orgMap.entrySet()) {
                converted.put(NamespaceTranslator.getOSGiNamespace(entry.getKey()), entry.getValue());
            }
            if ("osgi.wiring.bundle".equals(this.getNamespace())) {
                this.defaultAttribute(orgMap, converted, "osgi.wiring.bundle", orgMap.get("symbolicname"));
                this.defaultAttribute(orgMap, converted, "bundle-version", orgMap.get("version"));
            } else if ("osgi.wiring.package".equals(this.getNamespace()) && (bundleCap = this.getBundleCapability()) != null) {
                this.defaultAttribute(orgMap, converted, "bundle-symbolic-name", bundleCap.getAttributes().get("osgi.wiring.bundle"));
                this.defaultAttribute(orgMap, converted, "bundle-version", bundleCap.getAttributes().get("bundle-version"));
            }
            this.convertedAttributes = converted;
        }
        return this.convertedAttributes;
    }

    private void defaultAttribute(Map<String, Object> orgMap, Map<String, Object> converted, String newAttr, Object defVal) {
        if (converted.get(newAttr) == null) {
            converted.put(newAttr, defVal);
        }
    }

    @Override
    public Map<String, String> getDirectives() {
        return this.capability.getDirectives();
    }

    @Override
    public String getNamespace() {
        return NamespaceTranslator.getOSGiNamespace(this.capability.getName());
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    private org.osgi.resource.Capability getBundleCapability() {
        if (this.resource == null) {
            return null;
        }
        List<org.osgi.resource.Capability> caps = this.resource.getCapabilities("osgi.wiring.bundle");
        if (caps.size() > 0) {
            return caps.get(0);
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof org.osgi.resource.Capability)) {
            return false;
        }
        org.osgi.resource.Capability c = (org.osgi.resource.Capability)o;
        return c.getNamespace().equals(this.getNamespace()) && c.getAttributes().equals(this.getAttributes()) && c.getDirectives().equals(this.getDirectives()) && c.getResource().equals(this.getResource());
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 31 * result + this.getNamespace().hashCode();
        result = 31 * result + this.getAttributes().hashCode();
        result = 31 * result + this.getDirectives().hashCode();
        result = 31 * result + this.getResource().hashCode();
        return result;
    }
}

