/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundlerepository.impl;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.felix.bundlerepository.Capability;
import org.apache.felix.bundlerepository.Requirement;
import org.apache.felix.bundlerepository.Resource;
import org.apache.felix.bundlerepository.impl.FelixCapabilityAdapter;
import org.apache.felix.bundlerepository.impl.FelixRequirementAdapter;
import org.apache.felix.bundlerepository.impl.NamespaceTranslator;
import org.apache.felix.bundlerepository.impl.OSGiCapabilityImpl;
import org.apache.felix.bundlerepository.impl.OSGiRepositoryImpl;
import org.apache.felix.bundlerepository.impl.OSGiResourceHelper;
import org.osgi.service.repository.RepositoryContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FelixResourceAdapter
implements org.osgi.resource.Resource,
RepositoryContent {
    private final Resource resource;

    public FelixResourceAdapter(Resource resource) {
        this.resource = resource;
    }

    @Override
    public List<org.osgi.resource.Capability> getCapabilities(String namespace) {
        Capability[] capabilities;
        OSGiCapabilityImpl c;
        ArrayList<org.osgi.resource.Capability> result = new ArrayList<org.osgi.resource.Capability>();
        if (namespace == null || namespace.equals("osgi.identity")) {
            c = OSGiRepositoryImpl.newOSGiIdentityCapability(this.resource);
            c.setResource(this);
            result.add(c);
        }
        if (namespace == null || namespace.equals("osgi.content")) {
            c = OSGiRepositoryImpl.newOSGiContentCapability(this.resource);
            c.setResource(this);
            result.add(c);
        }
        namespace = NamespaceTranslator.getFelixNamespace(namespace);
        for (Capability capability : capabilities = this.resource.getCapabilities()) {
            if (namespace != null && !capability.getName().equals(namespace)) continue;
            result.add(new FelixCapabilityAdapter(capability, this));
        }
        result.trimToSize();
        return result;
    }

    @Override
    public InputStream getContent() {
        try {
            return new URL(this.resource.getURI()).openStream();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<org.osgi.resource.Requirement> getRequirements(String namespace) {
        namespace = NamespaceTranslator.getFelixNamespace(namespace);
        Requirement[] requirements = this.resource.getRequirements();
        ArrayList<org.osgi.resource.Requirement> result = new ArrayList<org.osgi.resource.Requirement>(requirements.length);
        for (Requirement requirement : requirements) {
            if (namespace != null && !requirement.getName().equals(namespace)) continue;
            result.add(new FelixRequirementAdapter(requirement, this));
        }
        result.trimToSize();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof org.osgi.resource.Resource)) {
            return false;
        }
        org.osgi.resource.Resource that = (org.osgi.resource.Resource)o;
        if (!OSGiResourceHelper.getTypeAttribute(that).equals(OSGiResourceHelper.getTypeAttribute(this))) {
            return false;
        }
        if (!OSGiResourceHelper.getSymbolicNameAttribute(that).equals(OSGiResourceHelper.getSymbolicNameAttribute(this))) {
            return false;
        }
        return OSGiResourceHelper.getVersionAttribute(that).equals(OSGiResourceHelper.getVersionAttribute(this));
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 31 * result + OSGiResourceHelper.getTypeAttribute(this).hashCode();
        result = 31 * result + OSGiResourceHelper.getSymbolicNameAttribute(this).hashCode();
        result = 31 * result + OSGiResourceHelper.getVersionAttribute(this).hashCode();
        return result;
    }

    public String toString() {
        org.osgi.resource.Capability c = this.getCapabilities("osgi.identity").iterator().next();
        Map<String, Object> atts = c.getAttributes();
        return "" + atts.get("osgi.identity") + ';' + atts.get("version") + ';' + atts.get("type");
    }
}

