/*
 * Decompiled with CFR 0.152.
 */
package eu.essilab.lablib.checkboxtree.examples;

import eu.essilab.lablib.checkboxtree.CheckboxTree;
import eu.essilab.lablib.checkboxtree.TreeCheckingEvent;
import eu.essilab.lablib.checkboxtree.TreeCheckingListener;
import eu.essilab.lablib.checkboxtree.TreeCheckingModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class KeyListenerTree
extends JFrame {
    private CheckboxTree checkboxTree = null;
    private JPanel jContentPane = null;

    public static void main(String[] args) {
        KeyListenerTree test = new KeyListenerTree();
        test.setVisible(true);
    }

    public KeyListenerTree() {
        this.setDefaultCloseOperation(3);
        this.setTitle("CheckboxTree");
        this.setSize(300, 600);
        this.setContentPane(this.getJContentPane());
    }

    private JScrollPane getCheckboxTree() {
        if (this.checkboxTree == null) {
            this.checkboxTree = new CheckboxTree();
            this.checkboxTree.addKeyListener(new RefreshListener());
            System.out.println(this.checkboxTree.toString());
            this.checkboxTree.getCheckingModel().setCheckingMode(TreeCheckingModel.CheckingMode.PROPAGATE);
            this.checkboxTree.setRootVisible(true);
            this.checkboxTree.setEnabled(true);
            this.checkboxTree.expandAll();
            DefaultMutableTreeNode mn = (DefaultMutableTreeNode)this.checkboxTree.getModel().getRoot();
            mn = (DefaultMutableTreeNode)mn.getChildAt(2);
            mn = (DefaultMutableTreeNode)mn.getChildAt(2);
            System.out.println("row number: " + this.checkboxTree.getRowForPath(new TreePath(mn.getPath())));
            this.checkboxTree.addCheckingPath(new TreePath(mn.getPath()));
            this.checkboxTree.addTreeCheckingListener(new TreeCheckingListener(){

                @Override
                public void valueChanged(TreeCheckingEvent e) {
                    TreePath[] cr;
                    System.out.println("checking set changed, leading path: " + ((TreeNode)e.getPath().getLastPathComponent()).toString());
                    System.out.println("checking roots: ");
                    for (TreePath path : cr = KeyListenerTree.this.checkboxTree.getCheckingRoots()) {
                        System.out.println(path.getLastPathComponent());
                    }
                }
            });
        }
        return new JScrollPane(this.checkboxTree);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getCheckboxTree(), "Center");
        }
        return this.jContentPane;
    }

    private class RefreshListener
    implements KeyListener {
        private RefreshListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            TreePath p = KeyListenerTree.this.checkboxTree.getSelectionPath();
            DefaultMutableTreeNode resource = null;
            if (p != null) {
                System.out.println("selection path: " + p.toString());
                resource = (DefaultMutableTreeNode)p.getLastPathComponent();
            }
            if (e.getKeyChar() == 'r' && resource != null) {
                TreeNode parent = resource.getParent();
                int index = parent.getIndex(resource);
                System.out.println("Removing " + resource.toString());
                resource.removeFromParent();
                DefaultTreeModel dtm = (DefaultTreeModel)KeyListenerTree.this.checkboxTree.getModel();
                dtm.nodesWereRemoved(parent, new int[]{index}, new TreeNode[]{resource});
            }
            if (e.getKeyChar() == 'a' && resource != null) {
                System.out.println("Adding to " + resource.toString());
                DefaultTreeModel dtm = (DefaultTreeModel)KeyListenerTree.this.checkboxTree.getModel();
                DefaultMutableTreeNode node = new DefaultMutableTreeNode("test");
                resource.add(node);
                dtm.nodesWereInserted(resource, new int[]{resource.getIndex(node)});
                System.out.println("posizione: " + resource.getIndex(node));
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }
}

