/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.maven.notifier;

import com.google.common.base.Stopwatch;
import fr.jcgay.maven.notifier.Configuration;
import fr.jcgay.maven.notifier.ConfigurationParser;
import fr.jcgay.maven.notifier.Notifier;
import fr.jcgay.maven.notifier.Status;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.maven.eventspy.EventSpy;
import org.apache.maven.execution.MavenExecutionResult;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

public abstract class AbstractCustomEventSpy
implements Notifier {
    protected Logger logger;
    protected Configuration configuration;
    private Stopwatch stopwatch = new Stopwatch();

    protected abstract void fireNotification(MavenExecutionResult var1);

    @Override
    public final void init(EventSpy.Context context) {
        this.stopwatch.start();
        this.initNotifier();
    }

    @Override
    public final void onEvent(MavenExecutionResult event) {
        this.stopwatch.stop();
        if (this.stopwatch.elapsedTime(TimeUnit.SECONDS) > (long)this.configuration.getThreshold() || this.isPersistent()) {
            this.fireNotification(event);
        } else {
            this.logger.debug("No notification sent because build ends before threshold: " + this.configuration.getThreshold() + "s.");
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void onFailWithoutProject(List<Throwable> exceptions) {
    }

    @Override
    public boolean shouldNotify() {
        return this.getClass().getName().contains(this.configuration.getImplementation());
    }

    @Requirement
    public void setConfiguration(ConfigurationParser configuration) {
        this.configuration = configuration.get();
    }

    @Requirement
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setStopwatch(Stopwatch stopwatch) {
        this.stopwatch = stopwatch;
    }

    protected void initNotifier() {
    }

    protected Status getBuildStatus(MavenExecutionResult result) {
        return result.hasExceptions() ? Status.FAILURE : Status.SUCCESS;
    }

    protected long elapsedTime() {
        return this.stopwatch.elapsedTime(TimeUnit.SECONDS);
    }

    protected boolean isPersistent() {
        return false;
    }
}

