/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.maven.notifier;

import com.google.common.annotations.VisibleForTesting;
import fr.jcgay.maven.notifier.Notifier;
import fr.jcgay.maven.notifier.UselessNotifier;
import java.util.List;
import org.apache.maven.eventspy.AbstractEventSpy;
import org.apache.maven.eventspy.EventSpy;
import org.apache.maven.execution.MavenExecutionResult;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

@Component(role=EventSpy.class, hint="notification", description="Send notification to indicate build status.")
public class NotificationEventSpyChooser
extends AbstractEventSpy {
    public static final String SKIP_NOTIFICATION = "skipNotification";
    @Requirement
    private Logger logger;
    @Requirement
    private List<Notifier> availableNotifiers;
    private Notifier activeNotifier;

    public void init(EventSpy.Context context) throws Exception {
        this.chooseNotifier();
        this.activeNotifier.init(context);
    }

    public void onEvent(Object event) throws Exception {
        if (this.shouldSendNotification()) {
            if (this.isExecutionResult(event) && this.hasFailedWithoutProject((MavenExecutionResult)event)) {
                this.activeNotifier.onFailWithoutProject(((MavenExecutionResult)event).getExceptions());
            } else if (this.isExecutionResult(event)) {
                this.activeNotifier.onEvent((MavenExecutionResult)event);
            }
        }
    }

    private boolean hasFailedWithoutProject(MavenExecutionResult event) {
        return event.getProject() == null && event.hasExceptions();
    }

    private boolean shouldSendNotification() {
        return !"true".equalsIgnoreCase(System.getProperty(SKIP_NOTIFICATION));
    }

    public void close() throws Exception {
        this.activeNotifier.close();
    }

    private boolean isExecutionResult(Object event) {
        return event instanceof MavenExecutionResult;
    }

    private void chooseNotifier() {
        for (Notifier notifier : this.availableNotifiers) {
            if (!notifier.shouldNotify()) continue;
            this.activeNotifier = notifier;
            this.logger.debug("Will notify build success/failure with: " + this.activeNotifier);
            return;
        }
        if (this.activeNotifier == null) {
            this.activeNotifier = UselessNotifier.EMPTY;
        }
    }

    @VisibleForTesting
    void setAvailableNotifiers(List<Notifier> availableNotifiers) {
        this.availableNotifiers = availableNotifiers;
    }
}

