/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.maven.notifier;

import com.google.common.base.Preconditions;
import java.net.URL;
import org.apache.maven.execution.BuildFailure;
import org.apache.maven.execution.BuildSuccess;
import org.apache.maven.execution.BuildSummary;

public enum Status {
    SUCCESS("/dialog-clean.png", "Success"),
    FAILURE("/dialog-error-5.png", "Failure"),
    SKIPPED(null, "Skipped");

    private final String icon;
    private final String message;

    private Status(String icon, String message) {
        this.icon = icon;
        this.message = (String)Preconditions.checkNotNull((Object)message);
    }

    public String message() {
        return this.message;
    }

    public static Status of(BuildSummary summary) {
        if (summary == null) {
            return SKIPPED;
        }
        if (summary instanceof BuildSuccess) {
            return SUCCESS;
        }
        if (summary instanceof BuildFailure) {
            return FAILURE;
        }
        throw new IllegalArgumentException(String.format("Summary status type [%s] is not handle.", summary.getClass().getName()));
    }

    public URL url() {
        return ((Object)((Object)this)).getClass().getResource(this.icon);
    }
}

