/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.maven.notifier.sound;

import fr.jcgay.maven.notifier.AbstractCustomEventSpy;
import fr.jcgay.maven.notifier.Notifier;
import fr.jcgay.maven.notifier.Status;
import fr.jcgay.maven.notifier.sound.EndListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.maven.execution.MavenExecutionResult;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.IOUtil;

@Component(role=Notifier.class, hint="sound")
public class SoundNotifier
extends AbstractCustomEventSpy {
    @Override
    public void onFailWithoutProject(List<Throwable> exceptions) {
        this.playSound(Status.FAILURE);
    }

    @Override
    protected void fireNotification(MavenExecutionResult event) {
        this.playSound(this.getBuildStatus(event));
    }

    private void playSound(Status status) {
        AudioInputStream ais = this.getAudioStream(status);
        if (ais == null) {
            this.logger.warn("Cannot get a sound to play. Skipping notification...");
            return;
        }
        this.play(ais);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void play(AudioInputStream ais) {
        try {
            Clip clip = AudioSystem.getClip();
            EndListener listener = new EndListener();
            clip.addLineListener(listener);
            clip.open(ais);
            this.playAndWait(clip, listener);
        }
        catch (LineUnavailableException e) {
            this.fail(e);
        }
        catch (IOException e) {
            this.fail(e);
        }
        finally {
            IOUtil.close((InputStream)ais);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void playAndWait(Clip clip, EndListener listener) {
        try {
            clip.start();
            listener.waitEnd();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            clip.close();
        }
    }

    private void fail(Exception e) {
        this.logger.debug("Error playing sound.", (Throwable)e);
    }

    private AudioInputStream getAudioStream(Status success) {
        try {
            return AudioSystem.getAudioInputStream(this.getUrl(success));
        }
        catch (UnsupportedAudioFileException e) {
            return this.noAudioStream(e);
        }
        catch (IOException e) {
            return this.noAudioStream(e);
        }
    }

    private AudioInputStream noAudioStream(Exception e) {
        this.logger.warn("Error reading audio stream.", (Throwable)e);
        return null;
    }

    private InputStream getUrl(Status status) {
        String sound = status == Status.SUCCESS ? "/109662__grunz__success.wav" : "/Sad_Trombone-Joe_Lamb-665429450.wav";
        return this.getClass().getResourceAsStream(sound);
    }
}

