/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.micronaut.camunda.bpm.feature;

import io.micronaut.core.annotation.Nullable;
import jakarta.inject.Singleton;
import java.util.Optional;
import org.camunda.bpm.engine.ProcessEngine;

@Singleton
public class CamundaVersion {
    private final Optional<String> version;

    public CamundaVersion() {
        this(ProcessEngine.class.getPackage());
    }

    protected CamundaVersion(Package pkg) {
        this.version = Optional.ofNullable(pkg.getImplementationVersion()).map(String::trim);
    }

    public CamundaVersion(@Nullable String version) {
        this.version = Optional.ofNullable(version);
    }

    public Optional<String> getVersion() {
        return this.version;
    }

    public boolean isEnterprise() {
        return this.version.map(s -> s.contains("-ee")).orElse(false);
    }
}

