/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.micronaut.camunda.bpm.feature;

import info.novatec.micronaut.camunda.bpm.feature.Configuration;
import info.novatec.micronaut.camunda.bpm.feature.JobExecutorCustomizer;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;

@Singleton
public class MnJobExecutor
extends JobExecutor {
    protected final ExecutorService ioExecutor;
    protected final boolean twoStageProcessEngine;

    public MnJobExecutor(@Named(value="scheduled") ExecutorService ioExecutor, JobExecutorCustomizer jobExecutorCustomizer, Configuration configuration) {
        this.ioExecutor = ioExecutor;
        this.twoStageProcessEngine = configuration.isTwoStageProcessEngine();
        jobExecutorCustomizer.customize(this);
    }

    public synchronized void registerProcessEngine(ProcessEngineImpl processEngine) {
        if (this.twoStageProcessEngine) {
            this.processEngines.add(processEngine);
        } else {
            super.registerProcessEngine(processEngine);
        }
    }

    protected void startExecutingJobs() {
        this.startJobAcquisitionThread();
    }

    protected void stopExecutingJobs() {
        this.stopJobAcquisitionThread();
    }

    public void executeJobs(List<String> jobIds, ProcessEngineImpl processEngine) {
        try {
            this.ioExecutor.execute(this.getExecuteJobsRunnable(jobIds, processEngine));
        }
        catch (RejectedExecutionException e) {
            this.logRejectedExecution(processEngine, jobIds.size());
            this.rejectedJobsHandler.jobsRejected(jobIds, processEngine, (JobExecutor)this);
        }
    }
}

