/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.micronaut.camunda.bpm.feature;

import info.novatec.micronaut.camunda.bpm.feature.ApplicationContextElResolver;
import info.novatec.micronaut.camunda.bpm.feature.CamundaVersion;
import info.novatec.micronaut.camunda.bpm.feature.Configuration;
import info.novatec.micronaut.camunda.bpm.feature.MnArtifactFactory;
import info.novatec.micronaut.camunda.bpm.feature.MnBeansResolverFactory;
import info.novatec.micronaut.camunda.bpm.feature.MnExpressionManager;
import info.novatec.micronaut.camunda.bpm.feature.MnJobExecutor;
import info.novatec.micronaut.camunda.bpm.feature.MnTelemetryRegistry;
import info.novatec.micronaut.camunda.bpm.feature.ProcessEngineConfigurationCustomizer;
import info.novatec.micronaut.camunda.bpm.feature.tx.MnTransactionContextFactory;
import info.novatec.micronaut.camunda.bpm.feature.tx.MnTransactionInterceptor;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.transaction.SynchronousTransactionManager;
import io.micronaut.transaction.TransactionDefinition;
import jakarta.inject.Singleton;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.builder.xml.XMLConfigBuilder;
import org.camunda.bpm.engine.history.CleanableHistoricCaseInstanceReport;
import org.camunda.bpm.engine.history.CleanableHistoricCaseInstanceReportResult;
import org.camunda.bpm.engine.history.HistoricCaseActivityInstance;
import org.camunda.bpm.engine.history.HistoricCaseActivityInstanceQuery;
import org.camunda.bpm.engine.history.HistoricCaseActivityStatistics;
import org.camunda.bpm.engine.history.HistoricCaseActivityStatisticsQuery;
import org.camunda.bpm.engine.history.HistoricCaseInstance;
import org.camunda.bpm.engine.history.HistoricCaseInstanceQuery;
import org.camunda.bpm.engine.impl.CleanableHistoricCaseInstanceReportImpl;
import org.camunda.bpm.engine.impl.HistoricCaseActivityInstanceQueryImpl;
import org.camunda.bpm.engine.impl.HistoricCaseActivityStatisticsQueryImpl;
import org.camunda.bpm.engine.impl.HistoricCaseInstanceQueryImpl;
import org.camunda.bpm.engine.impl.HistoryServiceImpl;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.RepositoryServiceImpl;
import org.camunda.bpm.engine.impl.cfg.IdGenerator;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEnginePlugin;
import org.camunda.bpm.engine.impl.cmmn.CaseServiceImpl;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionQueryImpl;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseInstanceQueryImpl;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandContextInterceptor;
import org.camunda.bpm.engine.impl.interceptor.CommandCounterInterceptor;
import org.camunda.bpm.engine.impl.interceptor.CommandInterceptor;
import org.camunda.bpm.engine.impl.interceptor.LogInterceptor;
import org.camunda.bpm.engine.impl.interceptor.ProcessApplicationContextInterceptor;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.CaseDefinitionQuery;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseExecutionQuery;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.CaseInstanceQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Introspected
public class MnProcessEngineConfiguration
extends ProcessEngineConfigurationImpl {
    private static final Logger log = LoggerFactory.getLogger(MnProcessEngineConfiguration.class);
    protected final SynchronousTransactionManager<Connection> transactionManager;
    protected final MnJobExecutor jobExecutor;
    protected final MnTelemetryRegistry telemetryRegistry;
    protected final MnBeansResolverFactory beansResolverFactory;
    protected final Environment environment;
    protected final CamundaVersion camundaVersion;
    protected final List<ProcessEnginePlugin> plugins;
    protected final boolean twoStageProcessEngine;

    public MnProcessEngineConfiguration(SynchronousTransactionManager<Connection> transactionManager, MnJobExecutor jobExecutor, Configuration configuration, MnTelemetryRegistry telemetryRegistry, Environment environment, CamundaVersion camundaVersion, ApplicationContext applicationContext, DataSource dataSource, IdGenerator idGenerator, MnArtifactFactory artifactFactory, MnBeansResolverFactory beansResolverFactory, List<ProcessEnginePlugin> plugins, ProcessEngineConfigurationCustomizer processEngineConfigurationCustomizer) {
        this.transactionManager = transactionManager;
        this.jobExecutor = jobExecutor;
        this.telemetryRegistry = telemetryRegistry;
        this.beansResolverFactory = beansResolverFactory;
        this.environment = environment;
        this.camundaVersion = camundaVersion;
        this.plugins = plugins;
        this.twoStageProcessEngine = configuration.isTwoStageProcessEngine();
        this.checkForDeprecatedConfiguration();
        this.mockUnsupportedCmmnMethods();
        this.setDataSource(dataSource);
        this.setTransactionsExternallyManaged(true);
        this.setIdGenerator(idGenerator);
        this.setExpressionManager(new MnExpressionManager(new ApplicationContextElResolver(applicationContext)));
        this.setArtifactFactory(artifactFactory);
        this.configureDefaultValues();
        this.applyGenericProperties(configuration);
        this.configureTelemetry();
        this.registerProcessEnginePlugins();
        processEngineConfigurationCustomizer.customize(this);
    }

    public org.apache.ibatis.session.Configuration createConfigurationStage2() {
        InputStreamReader reader = new InputStreamReader(this.getMyBatisXmlConfigurationSteamStage2());
        Properties properties = new Properties();
        if (this.isUseSharedSqlSessionFactory) {
            properties.put("prefix", "${@org.camunda.bpm.engine.impl.context.Context@getProcessEngineConfiguration().databaseTablePrefix}");
        } else {
            properties.put("prefix", this.databaseTablePrefix);
        }
        MnProcessEngineConfiguration.initSqlSessionFactoryProperties((Properties)properties, (String)this.databaseTablePrefix, (String)this.databaseType);
        XMLConfigBuilder parser = new XMLConfigBuilder((Reader)reader, "", properties);
        org.apache.ibatis.session.Configuration parserConfiguration = parser.getConfiguration();
        parserConfiguration.getSqlFragments().putAll(this.getSqlSessionFactory().getConfiguration().getSqlFragments());
        parser.parse();
        return parserConfiguration;
    }

    protected void initTransactionContextFactory() {
        if (this.transactionContextFactory == null) {
            this.transactionContextFactory = new MnTransactionContextFactory(this.transactionManager);
        }
    }

    protected void initJobExecutor() {
        this.setJobExecutor(this.jobExecutor);
        super.initJobExecutor();
    }

    protected void initScripting() {
        super.initScripting();
        this.getResolverFactories().add(this.beansResolverFactory);
    }

    protected InputStream getMyBatisXmlConfigurationSteam() {
        if (this.twoStageProcessEngine) {
            return this.getMyBatisXmlConfigurationSteamStage1();
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(super.getMyBatisXmlConfigurationSteam()));
        try {
            StringBuilder sb = new StringBuilder();
            while (reader.ready()) {
                String line = reader.readLine();
                if (!line.contains("<mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/Case")) {
                    sb.append(line);
                    sb.append("\n");
                    continue;
                }
                log.debug("Filtered out CMMN mapping {}", (Object)line);
            }
            return new ByteArrayInputStream(sb.toString().getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read MyBatis mappings.xml", e);
        }
    }

    protected InputStream getMyBatisXmlConfigurationSteamStage1() {
        String s = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE configuration PUBLIC \"-//mybatis.org//DTD Config 3.0//EN\" \"http://mybatis.org/dtd/mybatis-3-config.dtd\">\n\n<configuration>\n\t<settings>\n\t\t<setting name=\"lazyLoadingEnabled\" value=\"false\" />\n\t</settings>\n\t<mappers>\n        <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/Commons.xml\" />\n        <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/Authorization.xml\" />\n        <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/Tenant.xml\" />\n        <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/Deployment.xml\" />\n        <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/Incident.xml\" />\n        <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/Job.xml\" />\n        <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/JobDefinition.xml\" />\n        <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/ProcessDefinition.xml\" />\n        <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/Property.xml\" />\n        <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/Resource.xml\" />\n        <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/Task.xml\" />\n        <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/EventSubscription.xml\" />\n        <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/Filter.xml\" />\n        <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/User.xml\" />\n        <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/Group.xml\" />\n        <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/Membership.xml\" />\n        <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/CamundaFormDefinition.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/DecisionDefinition.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/DecisionRequirementsDefinition.xml\" />" + (this.getHistoryLevel() == HistoryLevel.HISTORY_LEVEL_FULL ? "    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/HistoricJobLog.xml\" />\n" : "") + "\n\t</mappers>\n</configuration>\n";
        return new ByteArrayInputStream(s.getBytes());
    }

    protected InputStream getMyBatisXmlConfigurationSteamStage2() {
        String s = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE configuration PUBLIC \"-//mybatis.org//DTD Config 3.0//EN\" \"http://mybatis.org/dtd/mybatis-3-config.dtd\">\n<configuration>\n\t<settings>\n\t\t<setting name=\"lazyLoadingEnabled\" value=\"false\" />\n\t</settings>\n\t<mappers>\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/Report.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/Attachment.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/Comment.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/Execution.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/HistoricActivityInstance.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/HistoricCaseActivityInstance.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/HistoricDetail.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/HistoricIncident.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/HistoricIdentityLinkLog.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/HistoricProcessInstance.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/HistoricCaseInstance.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/HistoricStatistics.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/HistoricVariableInstance.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/HistoricTaskInstance.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/HistoricTaskInstanceReport.xml\" />\n" + (this.getHistoryLevel() != HistoryLevel.HISTORY_LEVEL_FULL ? "    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/HistoricJobLog.xml\" />\n" : "") + "    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/HistoricExternalTaskLog.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/UserOperationLogEntry.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/IdentityInfo.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/IdentityLink.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/SchemaLogEntry.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/TableData.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/TaskMetrics.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/VariableInstance.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/Statistics.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/Metrics.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/ExternalTask.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/Batch.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/HistoricBatch.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/TenantMembership.xml\" />\n    <!-- DMN -->\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/HistoricDecisionInstance.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/HistoricDecisionInputInstance.xml\" />\n    <mapper resource=\"org/camunda/bpm/engine/impl/mapping/entity/HistoricDecisionOutputInstance.xml\" />\n\t</mappers>\n</configuration>\n";
        return new ByteArrayInputStream(s.getBytes());
    }

    protected Collection<? extends CommandInterceptor> getDefaultCommandInterceptorsTxRequired() {
        return this.getCommandInterceptors(false);
    }

    protected Collection<? extends CommandInterceptor> getDefaultCommandInterceptorsTxRequiresNew() {
        return this.getCommandInterceptors(true);
    }

    protected List<CommandInterceptor> getCommandInterceptors(boolean requiresNew) {
        return Arrays.asList(new CommandInterceptor[]{new LogInterceptor(), new CommandCounterInterceptor((ProcessEngineConfigurationImpl)this), new ProcessApplicationContextInterceptor((ProcessEngineConfigurationImpl)this), new MnTransactionInterceptor(this.transactionManager, requiresNew ? TransactionDefinition.Propagation.REQUIRES_NEW : TransactionDefinition.Propagation.REQUIRED), new CommandContextInterceptor(this.commandContextFactory, (ProcessEngineConfigurationImpl)this, requiresNew)});
    }

    protected void checkForDeprecatedConfiguration() {
        if (!this.environment.getPropertyEntries("camunda.bpm").isEmpty()) {
            String msg = "All properties with the prefix 'camunda.bpm.*' have been renamed to 'camunda.*'. Please update your configuration!";
            log.error(msg);
            throw new IllegalArgumentException(msg);
        }
    }

    protected void mockUnsupportedCmmnMethods() {
        this.repositoryService = new RepositoryServiceImpl(){

            public CaseDefinitionQuery createCaseDefinitionQuery() {
                return new CaseDefinitionQueryImpl(this.commandExecutor){

                    public long executeCount(CommandContext commandContext) {
                        return 0L;
                    }

                    public List<CaseDefinition> executeList(CommandContext commandContext, Page page) {
                        return Collections.emptyList();
                    }
                };
            }
        };
        this.caseService = new CaseServiceImpl(){

            public CaseInstanceQuery createCaseInstanceQuery() {
                return new CaseInstanceQueryImpl(this.commandExecutor){

                    public long executeCount(CommandContext commandContext) {
                        return 0L;
                    }

                    public List<CaseInstance> executeList(CommandContext commandContext, Page page) {
                        return Collections.emptyList();
                    }
                };
            }

            public CaseExecutionQuery createCaseExecutionQuery() {
                return new CaseExecutionQueryImpl(this.commandExecutor){

                    public long executeCount(CommandContext commandContext) {
                        return 0L;
                    }

                    public List<CaseExecution> executeList(CommandContext commandContext, Page page) {
                        return Collections.emptyList();
                    }
                };
            }
        };
        this.historyService = new HistoryServiceImpl(){

            public HistoricCaseInstanceQuery createHistoricCaseInstanceQuery() {
                return new HistoricCaseInstanceQueryImpl(this.commandExecutor){

                    public long executeCount(CommandContext commandContext) {
                        return 0L;
                    }

                    public List<HistoricCaseInstance> executeList(CommandContext commandContext, Page page) {
                        return Collections.emptyList();
                    }
                };
            }

            public HistoricCaseActivityInstanceQuery createHistoricCaseActivityInstanceQuery() {
                return new HistoricCaseActivityInstanceQueryImpl(this.commandExecutor){

                    public long executeCount(CommandContext commandContext) {
                        return 0L;
                    }

                    public List<HistoricCaseActivityInstance> executeList(CommandContext commandContext, Page page) {
                        return Collections.emptyList();
                    }
                };
            }

            public HistoricCaseActivityStatisticsQuery createHistoricCaseActivityStatisticsQuery(String caseDefinitionId) {
                return new HistoricCaseActivityStatisticsQueryImpl(caseDefinitionId, this.commandExecutor){

                    public long executeCount(CommandContext commandContext) {
                        return 0L;
                    }

                    public List<HistoricCaseActivityStatistics> executeList(CommandContext commandContext, Page page) {
                        return Collections.emptyList();
                    }
                };
            }

            public CleanableHistoricCaseInstanceReport createCleanableHistoricCaseInstanceReport() {
                return new CleanableHistoricCaseInstanceReportImpl(this.commandExecutor){

                    public long executeCount(CommandContext commandContext) {
                        return 0L;
                    }

                    public List<CleanableHistoricCaseInstanceReportResult> executeList(CommandContext commandContext, Page page) {
                        return Collections.emptyList();
                    }
                };
            }
        };
    }

    protected void configureTelemetry() {
        this.setTelemetryRegistry(this.telemetryRegistry);
        if (this.environment.getActiveNames().contains("test")) {
            this.setInitializeTelemetry(false);
            this.setTelemetryReporterActivate(false);
        } else if (Boolean.TRUE.equals(this.isInitializeTelemetry()) && this.isTelemetryReporterActivate() && !this.camundaVersion.getVersion().isPresent()) {
            log.warn("Disabling TelemetryReporter because required information 'Camunda Version' is not available.");
            this.setTelemetryReporterActivate(false);
        }
    }

    protected void configureDefaultValues() {
        this.setJobExecutorActivate(!this.environment.getActiveNames().contains("test"));
        this.setDatabaseSchemaUpdate("true");
    }

    protected void applyGenericProperties(Configuration configuration) {
        BeanIntrospection introspection = BeanIntrospection.getIntrospection(MnProcessEngineConfiguration.class);
        for (Map.Entry<String, Object> entry : configuration.getGenericProperties().getProperties().entrySet()) {
            BeanProperty property = (BeanProperty)introspection.getProperty(entry.getKey()).orElseThrow(() -> new RuntimeException("Invalid process engine property: " + (String)entry.getKey()));
            property.set((Object)this, this.resolveGenericPropertyValue(entry.getValue(), property.getType()));
        }
    }

    protected Object resolveGenericPropertyValue(Object value, Class<?> type) {
        if (type == Integer.TYPE) {
            return Integer.valueOf(String.valueOf(value));
        }
        if (type == Long.TYPE) {
            return Long.valueOf(String.valueOf(value));
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return Boolean.valueOf(String.valueOf(value));
        }
        if (type == String.class) {
            return String.valueOf(value);
        }
        return value;
    }

    public ProcessEngineConfigurationImpl setInitializeTelemetry(Boolean telemetryInitialized) {
        return super.setInitializeTelemetry(telemetryInitialized.booleanValue());
    }

    protected void registerProcessEnginePlugins() {
        log.info("Registering process engine plugins: {}", this.plugins);
        this.setProcessEnginePlugins(this.plugins);
    }
}

