/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.micronaut.camunda.bpm.feature;

import info.novatec.micronaut.camunda.bpm.feature.CamundaVersion;
import info.novatec.micronaut.camunda.bpm.feature.initialization.ParallelInitializationService;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.jdbc.BasicJdbcConfiguration;
import io.micronaut.transaction.SynchronousTransactionManager;
import jakarta.inject.Singleton;
import java.sql.Connection;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Factory
public class ProcessEngineFactory {
    private static final Logger log = LoggerFactory.getLogger(ProcessEngineFactory.class);

    @Singleton
    @Bean(preDestroy="close")
    public ProcessEngine processEngine(ProcessEngineConfiguration processEngineConfiguration, CamundaVersion camundaVersion, SynchronousTransactionManager<Connection> transactionManager, BasicJdbcConfiguration basicJdbcConfiguration, ParallelInitializationService parallelInitializationService) {
        if (camundaVersion.getVersion().isPresent()) {
            log.info("Camunda version: {}", (Object)camundaVersion.getVersion().get());
        } else {
            log.warn("The Camunda version cannot be determined. If you created a Fat/Uber/Shadow JAR then please consider using the Micronaut Application Plugin's 'dockerBuild' task to create a Docker image.");
        }
        log.info("Building process engine connected to {}", (Object)basicJdbcConfiguration.getUrl());
        Instant start = Instant.now();
        ProcessEngine processEngine = (ProcessEngine)transactionManager.executeWrite(transactionStatus -> processEngineConfiguration.buildProcessEngine());
        log.info("Started process engine in {}ms", (Object)ChronoUnit.MILLIS.between(start, Instant.now()));
        log.debug("Starting Camunda related services...");
        parallelInitializationService.process(processEngine);
        log.debug("Camunda related services started in {}ms", (Object)ChronoUnit.MILLIS.between(start, Instant.now()));
        return processEngine;
    }
}

