/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.micronaut.camunda.bpm.feature.initialization;

import info.novatec.micronaut.camunda.bpm.feature.Configuration;
import info.novatec.micronaut.camunda.bpm.feature.initialization.ParallelInitializationWithProcessEngine;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.util.StringUtils;
import io.micronaut.transaction.SynchronousTransactionManager;
import jakarta.inject.Singleton;
import java.sql.Connection;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requires(property="camunda.admin-user.id")
public class AdminUserCreator
implements ParallelInitializationWithProcessEngine {
    private static final Logger log = LoggerFactory.getLogger(AdminUserCreator.class);
    protected final Configuration.AdminUser adminUser;
    protected final SynchronousTransactionManager<Connection> transactionManager;

    public AdminUserCreator(Configuration configuration, SynchronousTransactionManager<Connection> transactionManager) {
        this.adminUser = configuration.getAdminUser();
        this.transactionManager = transactionManager;
    }

    @Override
    public void execute(ProcessEngine processEngine) {
        IdentityService identityService = processEngine.getIdentityService();
        AuthorizationService authorizationService = processEngine.getAuthorizationService();
        this.transactionManager.executeWrite(transactionStatus -> {
            if (!this.userAlreadyExists(identityService, this.adminUser.getId())) {
                this.createUser(identityService);
                if (!this.adminGroupAlreadyExists(identityService)) {
                    this.createAdminGroup(identityService);
                }
                this.createAdminGroupAuthorizations(authorizationService);
                identityService.createMembership(this.adminUser.getId(), "camunda-admin");
                log.info("Created initial Admin User: {}", (Object)this.adminUser.getId());
            }
            return null;
        });
    }

    protected boolean userAlreadyExists(IdentityService identityService, String userId) {
        return identityService.createUserQuery().userId(userId).singleResult() != null;
    }

    protected boolean adminGroupAlreadyExists(IdentityService identityService) {
        return identityService.createGroupQuery().groupId("camunda-admin").count() > 0L;
    }

    protected void createUser(IdentityService identityService) {
        User newUser = identityService.newUser(this.adminUser.getId());
        newUser.setPassword(this.adminUser.getPassword());
        newUser.setFirstName(this.adminUser.getFirstname().orElse(StringUtils.capitalize((String)this.adminUser.getId())));
        newUser.setLastName(this.adminUser.getLastname().orElse(StringUtils.capitalize((String)this.adminUser.getId())));
        newUser.setEmail(this.adminUser.getEmail().orElse(this.adminUser.getId() + "@localhost"));
        identityService.saveUser(newUser);
    }

    protected void createAdminGroup(IdentityService identityService) {
        Group camundaAdminGroup = identityService.newGroup("camunda-admin");
        camundaAdminGroup.setName("Camunda Administrators");
        camundaAdminGroup.setType("SYSTEM");
        identityService.saveGroup(camundaAdminGroup);
    }

    protected void createAdminGroupAuthorizations(AuthorizationService authorizationService) {
        for (Resources resource : Resources.values()) {
            if (authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"camunda-admin"}).resourceType((Resource)resource).resourceId("*").count() != 0L) continue;
            AuthorizationEntity groupAuth = new AuthorizationEntity(1);
            groupAuth.setGroupId("camunda-admin");
            groupAuth.setResource((Resource)resource);
            groupAuth.setResourceId("*");
            groupAuth.addPermission((Permission)Permissions.ALL);
            authorizationService.saveAuthorization((Authorization)groupAuth);
        }
    }
}

