/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.micronaut.camunda.bpm.feature.initialization;

import info.novatec.micronaut.camunda.bpm.feature.Configuration;
import info.novatec.micronaut.camunda.bpm.feature.initialization.ParallelInitializationWithProcessEngine;
import io.micronaut.context.annotation.Requires;
import jakarta.inject.Singleton;
import org.camunda.bpm.engine.FilterService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requires(property="camunda.filter.create")
public class FilterAllTaskCreator
implements ParallelInitializationWithProcessEngine {
    private static final Logger log = LoggerFactory.getLogger(FilterAllTaskCreator.class);
    protected final String filterName;

    public FilterAllTaskCreator(Configuration configuration) {
        this.filterName = configuration.getFilter().getCreate().orElseThrow(() -> new IllegalArgumentException("If property 'camunda.filter.create' is set it must have a value."));
    }

    @Override
    public void execute(ProcessEngine processEngine) {
        FilterService filterService = processEngine.getFilterService();
        Filter filter = (Filter)filterService.createFilterQuery().filterName(this.filterName).singleResult();
        if (filter == null) {
            filter = filterService.newTaskFilter(this.filterName);
            filterService.saveFilter(filter);
            log.info("Created new task filter: {}", (Object)this.filterName);
        }
    }
}

