/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.micronaut.camunda.bpm.feature.initialization;

import info.novatec.micronaut.camunda.bpm.feature.CamundaVersion;
import info.novatec.micronaut.camunda.bpm.feature.Configuration;
import info.novatec.micronaut.camunda.bpm.feature.initialization.ParallelInitializationWithProcessEngine;
import io.micronaut.context.annotation.Requires;
import jakarta.inject.Singleton;
import java.net.URL;
import java.util.Optional;
import java.util.Scanner;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requires(property="camunda.license-file")
public class LicenseKeyConfiguration
implements ParallelInitializationWithProcessEngine {
    private static final Logger log = LoggerFactory.getLogger(LicenseKeyConfiguration.class);
    protected static final String DEFAULT_LICENSE_FILE = "camunda-license.txt";
    protected static final String HEADER_FOOTER_REGEX = "(?i)[-\\s]*(BEGIN|END)\\s*(OPTIMIZE|CAMUNDA|CAMUNDA\\s*BPM)\\s*LICENSE\\s*KEY[-\\s]*";
    protected final CamundaVersion camundaVersion;
    protected String licenseKey;
    protected final Optional<URL> licenseFile;

    public LicenseKeyConfiguration(Configuration configuration, CamundaVersion camundaVersion) {
        this.camundaVersion = camundaVersion;
        this.licenseFile = configuration.getLicenseFile();
    }

    @Override
    public void execute(ProcessEngine processEngine) {
        ManagementService managementService = processEngine.getManagementService();
        if (!this.camundaVersion.isEnterprise()) {
            log.warn("You are not using the Camunda Enterprise Edition dependencies. The license is not needed and will be ignored.");
            return;
        }
        if (managementService.getLicenseKey() != null) {
            log.info("A license key is already registered and will be used. Please use the Camunda Cockpit to update it.");
            return;
        }
        this.licenseKey = this.licenseFile.isPresent() ? this.readLicenseKeyFromUrl(this.licenseFile.get()) : this.readLicenseKeyFromUrl(LicenseKeyConfiguration.class.getClassLoader().getResource(DEFAULT_LICENSE_FILE));
        if (this.licenseKey != null) {
            managementService.setLicenseKey(this.licenseKey);
            log.info("Registered new license key");
        } else {
            log.warn("Could not locate the referenced license key. The license can be registered in the Camunda Cockpit.");
        }
    }

    protected String readLicenseKeyFromUrl(URL licenseFileUrl) {
        try {
            Scanner scanner = new Scanner(licenseFileUrl.openStream(), "UTF-8").useDelimiter("\\A");
            if (scanner.hasNext()) {
                return scanner.next().replaceAll(HEADER_FOOTER_REGEX, "").replaceAll("\\n", "").trim();
            }
            return null;
        }
        catch (Exception e) {
            log.warn("Ignoring license file {}. Details: {}", (Object)licenseFileUrl, (Object)e.getMessage());
            return null;
        }
    }
}

