/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.micronaut.camunda.bpm.feature.rest;

import info.novatec.micronaut.camunda.bpm.feature.Configuration;
import info.novatec.micronaut.camunda.bpm.feature.initialization.ParallelInitializationWithoutProcessEngine;
import info.novatec.micronaut.camunda.bpm.feature.rest.RestApp;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import jakarta.inject.Singleton;
import java.util.EnumSet;
import java.util.EventListener;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.camunda.bpm.engine.rest.impl.FetchAndLockContextListener;
import org.camunda.bpm.engine.rest.security.auth.ProcessEngineAuthenticationFilter;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requirements(value={@Requires(beans={Server.class}), @Requires(property="camunda.rest.enabled", value="true")})
public class JettyServerCustomizerRuntimeRest
implements ParallelInitializationWithoutProcessEngine {
    private static final Logger log = LoggerFactory.getLogger(JettyServerCustomizerRuntimeRest.class);
    protected final Server server;
    protected final String contextPath;
    protected final boolean basicAuthEnabled;

    public JettyServerCustomizerRuntimeRest(Server server, Configuration configuration) {
        this.server = server;
        this.contextPath = configuration.getRest().getContextPath();
        this.basicAuthEnabled = configuration.getRest().isBasicAuthEnabled();
    }

    @Override
    public void execute() throws Exception {
        ServletContextHandler restServletContextHandler = new ServletContextHandler();
        restServletContextHandler.setContextPath(this.contextPath);
        restServletContextHandler.addServlet(new ServletHolder((Servlet)new ServletContainer((ResourceConfig)new RestApp())), "/*");
        restServletContextHandler.addEventListener((EventListener)new ServletContextListener(){

            public void contextInitialized(ServletContextEvent sce) {
                new FetchAndLockContextListener().contextInitialized(sce);
            }

            public void contextDestroyed(ServletContextEvent sce) {
            }
        });
        if (this.basicAuthEnabled) {
            FilterHolder filterHolder = new FilterHolder(ProcessEngineAuthenticationFilter.class);
            filterHolder.setInitParameter("authentication-provider", "org.camunda.bpm.engine.rest.security.auth.impl.HttpBasicAuthenticationProvider");
            restServletContextHandler.addFilter(filterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
            log.debug("REST API - Basic authentication enabled");
        }
        restServletContextHandler.setServer(this.server);
        restServletContextHandler.start();
        ((HandlerCollection)this.server.getHandler()).addHandler((Handler)restServletContextHandler);
        log.info("REST API initialized on {}/*", (Object)this.contextPath);
    }
}

