/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.micronaut.camunda.bpm.feature.tx;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.transaction.SynchronousTransactionManager;
import io.micronaut.transaction.support.TransactionSynchronization;
import io.micronaut.transaction.support.TransactionSynchronizationAdapter;
import io.micronaut.transaction.support.TransactionSynchronizationManager;
import java.sql.Connection;
import org.camunda.bpm.engine.impl.cfg.TransactionContext;
import org.camunda.bpm.engine.impl.cfg.TransactionListener;
import org.camunda.bpm.engine.impl.cfg.TransactionState;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;

public class MnTransactionContext
implements TransactionContext {
    protected final SynchronousTransactionManager<Connection> transactionManager;
    protected final CommandContext commandContext;
    protected TransactionState lastTransactionState = null;

    public MnTransactionContext(CommandContext commandContext, SynchronousTransactionManager<Connection> transactionManager) {
        this.commandContext = commandContext;
        this.transactionManager = transactionManager;
        TransactionSynchronizationManager.getSynchronousTransactionState((Object)new TransactionSynchronizationAdapter(){

            public void beforeCommit(boolean readOnly) {
                MnTransactionContext.this.lastTransactionState = TransactionState.COMMITTING;
            }

            public void afterCommit() {
                MnTransactionContext.this.lastTransactionState = TransactionState.COMMITTED;
            }

            public void beforeCompletion() {
                MnTransactionContext.this.lastTransactionState = TransactionState.ROLLINGBACK;
            }

            public void afterCompletion(@NonNull TransactionSynchronization.Status status) {
                if (TransactionSynchronization.Status.ROLLED_BACK == status) {
                    MnTransactionContext.this.lastTransactionState = TransactionState.ROLLED_BACK;
                }
            }
        });
    }

    public void commit() {
    }

    public void rollback() {
        this.transactionManager.getTransaction(null).setRollbackOnly();
    }

    public void addTransactionListener(TransactionState transactionState, final TransactionListener transactionListener) {
        TransactionSynchronizationAdapter transactionSynchronization;
        switch (transactionState) {
            case COMMITTING: {
                transactionSynchronization = new TransactionSynchronizationAdapter(){

                    public void beforeCommit(boolean readOnly) {
                        transactionListener.execute(MnTransactionContext.this.commandContext);
                    }
                };
                break;
            }
            case COMMITTED: {
                transactionSynchronization = new TransactionSynchronizationAdapter(){

                    public void afterCommit() {
                        transactionListener.execute(MnTransactionContext.this.commandContext);
                    }
                };
                break;
            }
            case ROLLINGBACK: {
                transactionSynchronization = new TransactionSynchronizationAdapter(){

                    public void beforeCompletion() {
                        transactionListener.execute(MnTransactionContext.this.commandContext);
                    }
                };
                break;
            }
            case ROLLED_BACK: {
                transactionSynchronization = new TransactionSynchronizationAdapter(){

                    public void afterCompletion(@NonNull TransactionSynchronization.Status status) {
                        if (TransactionSynchronization.Status.ROLLED_BACK == status) {
                            transactionListener.execute(MnTransactionContext.this.commandContext);
                        }
                    }
                };
                break;
            }
            default: {
                throw new IllegalStateException("Unknown transaction state: " + transactionState);
            }
        }
        TransactionSynchronizationManager.getSynchronousTransactionState((Object)transactionSynchronization);
    }

    public boolean isTransactionActive() {
        return TransactionSynchronizationManager.isActualTransactionActive() && TransactionState.ROLLED_BACK != this.lastTransactionState && TransactionState.ROLLINGBACK != this.lastTransactionState;
    }
}

