/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.distro.es;

import io.apiman.distro.es.DistroESConfig;
import java.io.File;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;

public class Bootstrapper
implements ServletContextListener {
    private static Node node = null;

    public void contextInitialized(ServletContextEvent sce) {
        DistroESConfig config = new DistroESConfig();
        System.out.println("------------------------------");
        System.out.println("Starting apiman-es.");
        System.out.println("   HTTP Ports: " + config.getHttpPortRange());
        System.out.println("   Transport Ports: " + config.getTransportPortRange());
        System.out.println("   Bind Host: " + config.getBindHost());
        System.out.println("------------------------------");
        String dataDir = System.getProperty("jboss.server.data.dir");
        if (dataDir == null) {
            System.err.println("\n\n-----Failed to find jboss.server.data.dir - are you trying to run apiman-es on an unsupported platform?\n-----\n\n");
            return;
        }
        File esHome = new File(dataDir, "es");
        System.out.println("ES Home: " + esHome);
        if (!esHome.exists()) {
            esHome.mkdirs();
        }
        ImmutableSettings.Builder settings = NodeBuilder.nodeBuilder().settings();
        settings.put("path.home", esHome.getAbsolutePath());
        settings.put("http.port", config.getHttpPortRange());
        settings.put("transport.tcp.port", config.getTransportPortRange());
        if (config.getBindHost() != null) {
            settings.put("network.bind_host", config.getBindHost());
        }
        String clusterName = "apiman";
        node = NodeBuilder.nodeBuilder().client(false).clusterName(clusterName).data(true).local(false).settings((Settings.Builder)settings).build();
        node.start();
        System.out.println("-----------------------------");
        System.out.println("apiman-es started!");
        System.out.println("-----------------------------");
    }

    public void contextDestroyed(ServletContextEvent sce) {
        node.stop();
        System.out.println("-----------------------------");
        System.out.println("apiman-es stopped!");
        System.out.println("-----------------------------");
    }
}

