/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.AssignMappingRuleToGroupStep1;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.response.AssignMappingRuleToGroupResponse;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.response.AssignMappingRuleToGroupResponseImpl;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class AssignMappingRuleToGroupCommandImpl
implements AssignMappingRuleToGroupStep1,
AssignMappingRuleToGroupStep1.AssignMappingRuleToGroupStep2,
AssignMappingRuleToGroupStep1.AssignMappingRuleToGroupStep3 {
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private String mappingRuleId;
    private String groupId;

    public AssignMappingRuleToGroupCommandImpl(HttpClient httpClient) {
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public AssignMappingRuleToGroupStep1.AssignMappingRuleToGroupStep2 mappingRuleId(String mappingRuleId) {
        this.mappingRuleId = mappingRuleId;
        return this;
    }

    @Override
    public AssignMappingRuleToGroupStep1.AssignMappingRuleToGroupStep3 groupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    @Override
    public FinalCommandStep<AssignMappingRuleToGroupResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<AssignMappingRuleToGroupResponse> send() {
        ArgumentUtil.ensureNotNullNorEmpty("groupId", this.groupId);
        ArgumentUtil.ensureNotNullNorEmpty("mappingRuleId", this.mappingRuleId);
        HttpCamundaFuture<AssignMappingRuleToGroupResponse> result = new HttpCamundaFuture<AssignMappingRuleToGroupResponse>();
        this.httpClient.put("/groups/" + this.groupId + "/mapping-rules/" + this.mappingRuleId, null, this.httpRequestConfig.build(), AssignMappingRuleToGroupResponseImpl::new, result);
        return result;
    }
}

