/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import com.google.protobuf.ByteString;
import io.camunda.client.CamundaClientConfiguration;
import io.camunda.client.CredentialsProvider;
import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.command.ClientException;
import io.camunda.client.api.command.DeployResourceCommandStep1;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.response.DeploymentEvent;
import io.camunda.client.impl.RetriableClientFutureImpl;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.command.StreamUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.response.DeploymentEventImpl;
import io.camunda.client.protocol.rest.DeploymentResult;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.grpc.stub.StreamObserver;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.core5.http.ContentType;

public final class DeployResourceCommandImpl
implements DeployResourceCommandStep1,
DeployResourceCommandStep1.DeployResourceCommandStep2 {
    private static final String RESOURCES_FIELD_NAME = "resources";
    private static final String TENANT_FIELD_NAME = "tenantId";
    private final MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create().setContentType(ContentType.MULTIPART_FORM_DATA);
    private final GatewayOuterClass.DeployResourceRequest.Builder requestBuilder = GatewayOuterClass.DeployResourceRequest.newBuilder();
    private final GatewayGrpc.GatewayStub asyncStub;
    private final Predicate<CredentialsProvider.StatusCode> retryPredicate;
    private Duration requestTimeout;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private boolean useRest;
    private final JsonMapper jsonMapper;
    private String tenantId;

    public DeployResourceCommandImpl(GatewayGrpc.GatewayStub asyncStub, CamundaClientConfiguration config, Predicate<CredentialsProvider.StatusCode> retryPredicate, HttpClient httpClient, boolean preferRestOverGrpc, JsonMapper jsonMapper) {
        this.asyncStub = asyncStub;
        this.requestTimeout = config.getDefaultRequestTimeout();
        this.retryPredicate = retryPredicate;
        this.tenantId(config.getDefaultTenantId());
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.useRest = preferRestOverGrpc;
        this.jsonMapper = jsonMapper;
        this.requestTimeout(this.requestTimeout);
    }

    @Deprecated
    public DeployResourceCommandImpl(GatewayGrpc.GatewayStub asyncStub, Duration requestTimeout, Predicate<CredentialsProvider.StatusCode> retryPredicate, HttpClient httpClient, boolean preferRestOverGrpc, JsonMapper jsonMapper) {
        this.asyncStub = asyncStub;
        this.requestTimeout = requestTimeout;
        this.retryPredicate = retryPredicate;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.useRest = preferRestOverGrpc;
        this.jsonMapper = jsonMapper;
        this.tenantId("<default>");
        this.requestTimeout(requestTimeout);
    }

    @Override
    public DeployResourceCommandStep1.DeployResourceCommandStep2 addResourceBytes(byte[] resource, String resourceName) {
        if (this.useRest) {
            this.multipartEntityBuilder.addBinaryBody(RESOURCES_FIELD_NAME, resource, ContentType.APPLICATION_OCTET_STREAM, resourceName);
            return this;
        }
        this.requestBuilder.addResources(GatewayOuterClass.Resource.newBuilder().setName(resourceName).setContent(ByteString.copyFrom((byte[])resource)).build());
        return this;
    }

    @Override
    public DeployResourceCommandStep1.DeployResourceCommandStep2 addResourceString(String resource, Charset charset, String resourceName) {
        return this.addResourceBytes(resource.getBytes(charset), resourceName);
    }

    @Override
    public DeployResourceCommandStep1.DeployResourceCommandStep2 addResourceStringUtf8(String resourceString, String resourceName) {
        return this.addResourceString(resourceString, StandardCharsets.UTF_8, resourceName);
    }

    @Override
    public DeployResourceCommandStep1.DeployResourceCommandStep2 addResourceStream(InputStream resourceStream, String resourceName) {
        ArgumentUtil.ensureNotNull("resource stream", resourceStream);
        try {
            byte[] bytes = StreamUtil.readInputStream(resourceStream);
            return this.addResourceBytes(bytes, resourceName);
        }
        catch (IOException e) {
            String exceptionMsg = String.format("Cannot deploy bpmn resource from stream. %s", e.getMessage());
            throw new ClientException(exceptionMsg, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DeployResourceCommandStep1.DeployResourceCommandStep2 addResourceFromClasspath(String classpathResource) {
        ArgumentUtil.ensureNotNull("classpath resource", classpathResource);
        try (InputStream resourceStream = this.getClass().getClassLoader().getResourceAsStream(classpathResource);){
            if (resourceStream == null) throw new FileNotFoundException(classpathResource);
            DeployResourceCommandStep1.DeployResourceCommandStep2 deployResourceCommandStep2 = this.addResourceStream(resourceStream, classpathResource);
            return deployResourceCommandStep2;
        }
        catch (IOException e) {
            String exceptionMsg = String.format("Cannot deploy resource from classpath. %s", e.getMessage());
            throw new RuntimeException(exceptionMsg, e);
        }
    }

    @Override
    public DeployResourceCommandStep1.DeployResourceCommandStep2 addResourceFile(String filename) {
        DeployResourceCommandStep1.DeployResourceCommandStep2 deployResourceCommandStep2;
        ArgumentUtil.ensureNotNull("filename", filename);
        FileInputStream resourceStream = new FileInputStream(filename);
        try {
            deployResourceCommandStep2 = this.addResourceStream(resourceStream, filename);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)resourceStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                String exceptionMsg = String.format("Cannot deploy resource from file. %s", e.getMessage());
                throw new RuntimeException(exceptionMsg, e);
            }
        }
        ((InputStream)resourceStream).close();
        return deployResourceCommandStep2;
    }

    @Override
    public DeployResourceCommandStep1.DeployResourceCommandStep2 addProcessModel(BpmnModelInstance processDefinition, String resourceName) {
        ArgumentUtil.ensureNotNull("process model", processDefinition);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Bpmn.writeModelToStream((OutputStream)outStream, (BpmnModelInstance)processDefinition);
        return this.addResourceBytes(outStream.toByteArray(), resourceName);
    }

    @Override
    public FinalCommandStep<DeploymentEvent> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<DeploymentEvent> send() {
        if (this.useRest) {
            this.multipartEntityBuilder.addTextBody(TENANT_FIELD_NAME, this.tenantId);
            return this.sendRestRequest();
        }
        return this.sendGrpcRequest();
    }

    @Override
    public DeployResourceCommandStep1.DeployResourceCommandStep2 tenantId(String tenantId) {
        this.tenantId = tenantId;
        this.requestBuilder.setTenantId(tenantId);
        return this;
    }

    @Override
    public DeployResourceCommandStep1.DeployResourceCommandStep2 useRest() {
        this.useRest = true;
        return this;
    }

    @Override
    public DeployResourceCommandStep1.DeployResourceCommandStep2 useGrpc() {
        this.useRest = false;
        return this;
    }

    private CamundaFuture<DeploymentEvent> sendRestRequest() {
        HttpCamundaFuture<DeploymentEvent> result = new HttpCamundaFuture<DeploymentEvent>();
        this.httpClient.postMultipart("/deployments", this.multipartEntityBuilder, this.httpRequestConfig.build(), DeploymentResult.class, DeploymentEventImpl::new, result);
        return result;
    }

    private CamundaFuture<DeploymentEvent> sendGrpcRequest() {
        GatewayOuterClass.DeployResourceRequest request = this.requestBuilder.build();
        RetriableClientFutureImpl<DeploymentEvent, GatewayOuterClass.DeployResourceResponse> future = new RetriableClientFutureImpl<DeploymentEvent, GatewayOuterClass.DeployResourceResponse>(DeploymentEventImpl::new, this.retryPredicate, streamObserver -> this.sendGrpcRequest(request, (StreamObserver)streamObserver));
        this.sendGrpcRequest(request, (StreamObserver)future);
        return future;
    }

    private void sendGrpcRequest(GatewayOuterClass.DeployResourceRequest request, StreamObserver streamObserver) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).deployResource(request, streamObserver);
    }
}

